local _, class = UnitClass("player")

local monk = false
local druid = false
local deathknight = false
local paladin = false
local warrior = false

if class == "MONK" then
	monk = true
elseif class == "DRUID" then
	druid = true
elseif class == "DEATHKNIGHT" then
	deathknight = true
elseif class == "PALADIN" then
	paladin = true
elseif class == "WARRIOR" then
	warrior = true
else
	-- DEFAULT_CHAT_FRAME:AddMessage( "Not supported Class " .. class );
	-- return
end

--- Basic Frames
local currentSelectedRessource0 = ""
local currentSelectedRessource1 = ""
local currentSelectedRessource2 = ""
local onLoadProcess = false
local width = 30
local height = 30
local iconFontSize = 10
local resolveId = GetSpellInfo(158300)
local bagFrame = nil
local stanceFrame = nil
local menuFrame = nil

local experienceFrame = CreateFrame("Frame","experienceFrame")
experienceFrame:SetBackdrop({
      		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
      		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
      		tile=1, tileSize=32, edgeSize=15, 
      		insets={left=0, right=0, top=0, bottom=0}
	})

local factionFrame = CreateFrame("Frame","factionFrame")
factionFrame:SetBackdrop({
      		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
      		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
      		tile=1, tileSize=32, edgeSize=15, 
      		insets={left=0, right=0, top=0, bottom=0}
	})

local dynamicBuffFrame = CreateFrame("Frame","dynamicBuffFrame")
dynamicBuffFrame:SetBackdrop({
      		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
      		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
      		tile=1, tileSize=32, edgeSize=15, 
      		insets={left=0, right=0, top=0, bottom=0}
	})


local dynamicDebuffFrame = CreateFrame("Frame","dynamicDebuffFrame")
dynamicDebuffFrame:SetBackdrop({
      		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
      		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
      		tile=1, tileSize=32, edgeSize=15, 
      		insets={left=0, right=0, top=0, bottom=0}
	})

local statusbarFrame = CreateFrame("Frame","statusbarFrame")
statusbarFrame:SetBackdrop({
      		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
      		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
      		tile=1, tileSize=32, edgeSize=15, 
      		insets={left=0, right=0, top=0, bottom=0}
	})

local castbarFrame = CreateFrame("Frame","castbarFrame")
castbarFrame:SetBackdrop({
      		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
      		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
      		tile=1, tileSize=32, edgeSize=15, 
      		insets={left=0, right=0, top=0, bottom=0}
	})

local resolve_frame = CreateFrame("Frame", "resolveFrame ")
resolve_frame:SetSize(300, 40)
resolve_frame:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
resolve_frame:SetBackdrop({
	bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
	edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
	tile=1, tileSize=32, edgeSize=15, 
	insets={left=0, right=0, top=0, bottom=0}
})
resolve_frame:Show()

resolve_frame.icon = resolve_frame:CreateTexture("Icon", "OVERLAY")
resolve_frame.icon:SetWidth(40)
resolve_frame.icon:SetPoint("TOPRIGHT", resolve_frame, "TOPLEFT", 0, 0)
resolve_frame.icon:SetPoint("BOTTOMRIGHT", resolve_frame, "BOTTOMLEFT", 0, 0)
resolve_frame.icon:SetTexture("Interface\\Icons\\Spell_Shadow_Charm")
resolve_frame.icon:SetTexCoord(0.07, 0.9, 0.07, 0.90)
resolve_frame.icon:Show()

local resolve_frame_perc = CreateFrame("StatusBar", nil, resolve_frame)
resolve_frame_perc:SetPoint("TOPLEFT", resolve_frame, "TOPLEFT", 5, -5)
resolve_frame_perc:SetWidth(290)
resolve_frame_perc:SetHeight(30)
resolve_frame_perc:SetMinMaxValues(0,240)
resolve_frame_perc:SetStatusBarTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
resolve_frame_perc:GetStatusBarTexture():SetHorizTile(false)
resolve_frame_perc:GetStatusBarTexture():SetVertTile(false)

resolve_frame_perc.bg = resolve_frame_perc:CreateTexture(nil, "BACKGROUND")
resolve_frame_perc.bg:SetTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
resolve_frame_perc.bg:SetAllPoints(true)

resolve_frame_perc.value = resolve_frame_perc:CreateFontString(nil, "OVERLAY")
resolve_frame_perc.value:SetPoint("CENTER", resolve_frame_perc, "CENTER", 0, 0)
resolve_frame_perc.value:SetFont("Fonts\\FRIZQT__.TTF", 15, "OUTLINE")
resolve_frame_perc.value:SetJustifyH("CENTER")
resolve_frame_perc.value:SetShadowOffset(1, -1)
resolve_frame_perc.value:SetText("0 % / 0 dtps")

resolve_frame_perc.value:SetTextColor(1, 1, 1)
resolve_frame_perc:SetStatusBarColor(1, 1, 1)
resolve_frame_perc.bg:SetVertexColor(0.65, 0.65, 0.65)

resolve_frame:SetMovable(true)
resolve_frame:EnableMouse(true)	
resolve_frame:RegisterForDrag("LeftButton")
resolve_frame:SetScript("OnDragStart", function(self) self:StartMoving() end)
resolve_frame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)

local experienceBar1 = CreateFrame("StatusBar", nil, experienceFrame)
experienceBar1:SetPoint("TOPLEFT", experienceFrame, "TOPLEFT", 5, -5)
experienceBar1:SetWidth(290)
experienceBar1:SetHeight(10)
experienceBar1:SetMinMaxValues(0,100)
experienceBar1:SetStatusBarTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
experienceBar1:GetStatusBarTexture():SetHorizTile(false)
experienceBar1:GetStatusBarTexture():SetVertTile(false)

experienceBar1.bg = experienceBar1:CreateTexture(nil, "BACKGROUND")
experienceBar1.bg:SetTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
experienceBar1.bg:SetAllPoints(true)

experienceBar1.value = experienceBar1:CreateFontString(nil, "OVERLAY")
experienceBar1.value:SetPoint("LEFT", experienceBar1, "LEFT", 0, 0)
experienceBar1.value:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")
experienceBar1.value:SetJustifyH("LEFT")
experienceBar1.value:SetShadowOffset(1, -1)
experienceBar1.value:SetText("0/0".. " xp")

experienceBar1.value:SetTextColor(0, 1, 0)
experienceBar1:SetStatusBarColor(0, 1, 0)
experienceBar1.bg:SetVertexColor(0, 0.65, 0)

experienceFrame:SetWidth(300)
experienceFrame:SetHeight(20)
experienceFrame:SetPoint("TOP",UIParent,"TOP",-300,0)
experienceFrame:EnableMouse(true)
experienceFrame:SetMovable(true)
experienceFrame:RegisterForDrag("LeftButton")
experienceFrame:SetScript("OnDragStart", function(self) self:StartMoving() end)
experienceFrame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
experienceFrame:SetFrameStrata("FULLSCREEN_DIALOG")

local factionBar1 = CreateFrame("StatusBar", nil, factionFrame)
factionBar1:SetPoint("TOPLEFT", factionFrame, "TOPLEFT", 5, -5)
factionBar1:SetWidth(290)
factionBar1:SetHeight(10)
factionBar1:SetMinMaxValues(0,100)
factionBar1:SetStatusBarTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
factionBar1:GetStatusBarTexture():SetHorizTile(false)
factionBar1:GetStatusBarTexture():SetVertTile(false)

factionBar1.bg = factionBar1:CreateTexture(nil, "BACKGROUND")
factionBar1.bg:SetTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
factionBar1.bg:SetAllPoints(true)

factionBar1.value = factionBar1:CreateFontString(nil, "OVERLAY")
factionBar1.value:SetPoint("LEFT", factionBar1, "LEFT", 0, 0)
factionBar1.value:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")
factionBar1.value:SetJustifyH("LEFT")
factionBar1.value:SetShadowOffset(1, -1)
factionBar1.value:SetText("0/0".. " xp")

factionBar1.value:SetTextColor(1, 1, 0)
factionBar1:SetStatusBarColor(1, 1, 0)
factionBar1.bg:SetVertexColor(0.65, 0.65, 0)

factionFrame:SetWidth(300)
factionFrame:SetHeight(20)
factionFrame:SetPoint("TOP",UIParent,"TOP",300,0)
factionFrame:EnableMouse(true)
factionFrame:SetMovable(true)
factionFrame:RegisterForDrag("LeftButton")
factionFrame:SetScript("OnDragStart", function(self) self:StartMoving() end)
factionFrame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
factionFrame:SetFrameStrata("FULLSCREEN_DIALOG")

local ressourceBar0 = CreateFrame("StatusBar", nil, statusbarFrame)
ressourceBar0:SetPoint("TOPLEFT", statusbarFrame, "TOPLEFT", 5, -10)
ressourceBar0:SetWidth(180)
ressourceBar0:SetHeight(10)
ressourceBar0:SetMinMaxValues(0,100)
ressourceBar0:SetStatusBarTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
ressourceBar0:GetStatusBarTexture():SetHorizTile(false)
ressourceBar0:GetStatusBarTexture():SetVertTile(false)
ressourceBar0:SetStatusBarColor(0, 1, 0)

ressourceBar0.bg = ressourceBar0:CreateTexture(nil, "BACKGROUND")
ressourceBar0.bg:SetTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
ressourceBar0.bg:SetAllPoints(true)
ressourceBar0.bg:SetVertexColor(0, 0.35, 0)

ressourceBar0.value = ressourceBar0:CreateFontString(nil, "OVERLAY")
ressourceBar0.value:SetPoint("LEFT", ressourceBar0, "LEFT", 4, 0)
ressourceBar0.value:SetFont("Fonts\\FRIZQT__.TTF", 16, "OUTLINE")
ressourceBar0.value:SetJustifyH("LEFT")
ressourceBar0.value:SetShadowOffset(1, -1)
ressourceBar0.value:SetTextColor(0, 1, 0)
ressourceBar0.value:SetText("100%")

local ressourceBar1 = CreateFrame("StatusBar", nil, statusbarFrame)
ressourceBar1:SetPoint("TOPLEFT", statusbarFrame, "TOPLEFT", 5, -25)
ressourceBar1:SetWidth(180)
ressourceBar1:SetHeight(10)
ressourceBar1:SetMinMaxValues(0,100)
ressourceBar1:SetStatusBarTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
ressourceBar1:GetStatusBarTexture():SetHorizTile(false)
ressourceBar1:GetStatusBarTexture():SetVertTile(false)

ressourceBar1.bg = ressourceBar1:CreateTexture(nil, "BACKGROUND")
ressourceBar1.bg:SetTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
ressourceBar1.bg:SetAllPoints(true)

ressourceBar1.value = ressourceBar1:CreateFontString(nil, "OVERLAY")
ressourceBar1.value:SetPoint("LEFT", ressourceBar1, "LEFT", 4, 0)
ressourceBar1.value:SetFont("Fonts\\FRIZQT__.TTF", 16, "OUTLINE")
ressourceBar1.value:SetJustifyH("LEFT")
ressourceBar1.value:SetShadowOffset(1, -1)
ressourceBar1.value:SetText("100%")

local ressourceBar2 = CreateFrame("StatusBar", nil, statusbarFrame)
ressourceBar2:SetPoint("TOPLEFT", statusbarFrame, "TOPLEFT", 5, -40)
ressourceBar2:SetWidth(180)
ressourceBar2:SetHeight(10)
ressourceBar2:SetMinMaxValues(0,100)
ressourceBar2:SetStatusBarTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
ressourceBar2:GetStatusBarTexture():SetHorizTile(false)
ressourceBar2:GetStatusBarTexture():SetVertTile(false)

ressourceBar2.bg = ressourceBar2:CreateTexture(nil, "BACKGROUND")
ressourceBar2.bg:SetTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
ressourceBar2.bg:SetAllPoints(true)

ressourceBar2.value = ressourceBar2:CreateFontString(nil, "OVERLAY")
ressourceBar2.value:SetPoint("LEFT", ressourceBar2, "LEFT", 4, 0)
ressourceBar2.value:SetFont("Fonts\\FRIZQT__.TTF", 16, "OUTLINE")
ressourceBar2.value:SetJustifyH("LEFT")
ressourceBar2.value:SetShadowOffset(1, -1)
ressourceBar2.value:SetText("100%")

dynamicBuffFrame:SetWidth((6*width)+10)
dynamicBuffFrame:SetHeight((height)+10)
dynamicBuffFrame:SetPoint("CENTER",UIParent,"CENTER",300,0)
dynamicBuffFrame:EnableMouse(true)
dynamicBuffFrame:SetMovable(true)
dynamicBuffFrame:RegisterForDrag("LeftButton")
dynamicBuffFrame:SetScript("OnDragStart", function(self) self:StartMoving() end)
dynamicBuffFrame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
dynamicBuffFrame:SetFrameStrata("FULLSCREEN_DIALOG")

dynamicDebuffFrame:SetWidth((6*width)+10)
dynamicDebuffFrame:SetHeight((height)+10)
dynamicDebuffFrame:SetPoint("CENTER",UIParent,"CENTER",0,-150)
dynamicDebuffFrame:EnableMouse(true)
dynamicDebuffFrame:SetMovable(true)
dynamicDebuffFrame:RegisterForDrag("LeftButton")
dynamicDebuffFrame:SetScript("OnDragStart", function(self) self:StartMoving() end)
dynamicDebuffFrame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
dynamicDebuffFrame:SetFrameStrata("FULLSCREEN_DIALOG")

castbarFrame:SetWidth(190)
castbarFrame:SetHeight(40)
castbarFrame:SetPoint("CENTER",UIParent,"CENTER",0,150)
castbarFrame:EnableMouse(true)
castbarFrame:SetMovable(true)
castbarFrame:RegisterForDrag("LeftButton")
castbarFrame:SetScript("OnDragStart", function(self) self:StartMoving() end)
castbarFrame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
castbarFrame:SetFrameStrata("FULLSCREEN_DIALOG")

local castbar1 = CreateFrame("StatusBar", nil, castbarFrame)
castbar1:SetPoint("TOPLEFT", castbarFrame, "TOPLEFT", 5, -5)
castbar1:SetWidth(180)
castbar1:SetHeight(30)
castbar1:SetMinMaxValues(0,100)
castbar1:SetStatusBarTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
castbar1:GetStatusBarTexture():SetHorizTile(false)
castbar1:GetStatusBarTexture():SetVertTile(false)
castbar1:SetValue(0)

castbar1.bg = castbar1:CreateTexture(nil, "BACKGROUND")
castbar1.bg:SetTexture("Interface\\TARGETINGFRAME\\UI-StatusBar")
castbar1.bg:SetAllPoints(true)

castbar1.value = castbar1:CreateFontString(nil, "OVERLAY")
castbar1.value:SetPoint("CENTER", castbar1, "CENTER", 0, 0)
castbar1.value:SetFont("Fonts\\FRIZQT__.TTF", 16, "OUTLINE")
castbar1.value:SetJustifyH("CENTER")
castbar1.value:SetShadowOffset(1, -1)
castbar1.value:SetAllPoints(true)
castbar1.value:SetText("")

castbar1.value:SetTextColor(1, 1, 0)
castbar1:SetStatusBarColor(0.65, 0.65, 0)
castbar1.bg:SetVertexColor(0.65, 0.65, 0)

statusbarFrame:SetWidth(190)
statusbarFrame:SetHeight(60)
statusbarFrame:SetPoint("CENTER",UIParent,"CENTER",-300,0)
statusbarFrame:EnableMouse(true)
statusbarFrame:SetMovable(true)
statusbarFrame:RegisterForDrag("LeftButton")
statusbarFrame:SetScript("OnDragStart", function(self) self:StartMoving() end)
statusbarFrame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
statusbarFrame:SetFrameStrata("FULLSCREEN_DIALOG")

local buff1Icon = CreateFrame("Frame","buff1Icon",dynamicBuffFrame)
local buff2Icon = CreateFrame("Frame","buff1Icon",dynamicBuffFrame)
local buff3Icon = CreateFrame("Frame","buff1Icon",dynamicBuffFrame)
local buff4Icon = CreateFrame("Frame","buff1Icon",dynamicBuffFrame)
local buff5Icon = CreateFrame("Frame","buff1Icon",dynamicBuffFrame)
local buff6Icon = CreateFrame("Frame","buff1Icon",dynamicBuffFrame)

local debuff1Icon = CreateFrame("Frame","debuff1Icon",dynamicBuffFrame)
local debuff2Icon = CreateFrame("Frame","debuff2Icon",dynamicBuffFrame)
local debuff3Icon = CreateFrame("Frame","debuff3Icon",dynamicBuffFrame)
local debuff4Icon = CreateFrame("Frame","debuff4Icon",dynamicBuffFrame)
local debuff5Icon = CreateFrame("Frame","debuff5Icon",dynamicBuffFrame)
local debuff6Icon = CreateFrame("Frame","debuff6Icon",dynamicBuffFrame)

-- CONFIG

MyAddon = {};
MyAddon.panel = CreateFrame( "Frame", "MyAddon", UIParent );
MyAddon.panel.name = "Brewmaster";

local showBuffs = CreateFrame("CheckButton", "ShowBuffs", MyAddon.panel, "UICheckButtonTemplate")
showBuffs:ClearAllPoints()
showBuffs:SetPoint("TOPLEFT", 10, -10)
_G[showBuffs:GetName() .. "Text"]:SetText("ShowBuffsOnPlayer")

local showDebuffs = CreateFrame("CheckButton", "ShowDebuffs", MyAddon.panel, "UICheckButtonTemplate")
showDebuffs:ClearAllPoints()
showDebuffs:SetPoint("TOPLEFT", 10, -40)
_G[showDebuffs:GetName() .. "Text"]:SetText("ShowDebuffsOnPlayer")

local useBrewmasterLookAndFeelConfig = CreateFrame("CheckButton", "UseBrewmasterLookAndFeel", MyAddon.panel, "UICheckButtonTemplate")
useBrewmasterLookAndFeelConfig:ClearAllPoints()
useBrewmasterLookAndFeelConfig:SetPoint("TOPLEFT", 10, -70)
_G[useBrewmasterLookAndFeelConfig:GetName() .. "Text"]:SetText("UseBrewmasterLookAndFeelConfig (Reload UI)")

local reloadUiButton = CreateFrame("Button", "rTestReloadButton", MyAddon.panel, "UIPanelButtonTemplate")
reloadUiButton:SetPoint("TOPLEFT", 10, -110)
local text = _G[reloadUiButton:GetName().."Text"]
text:SetText("Reload UI")
reloadUiButton:SetWidth(text:GetStringWidth()+30)
reloadUiButton:SetHeight(text:GetStringHeight()+20)
reloadUiButton:HookScript("OnClick", ReloadUI)

InterfaceOptions_AddCategory(MyAddon.panel);

MyAddon.lookAndFeelPanel = CreateFrame( "Frame", "lookAndFeelPanel", MyAddon.panel);
MyAddon.lookAndFeelPanel.name = "Look and Feel";
MyAddon.lookAndFeelPanel.parent = MyAddon.panel.name;

local lookAndFeelBorderFrame = CreateFrame("CheckButton","lookAndFeelBorderFrame",MyAddon.lookAndFeelPanel,"UICheckButtonTemplate")
lookAndFeelBorderFrame:SetPoint("TOPLEFT",5,-10)
lookAndFeelBorderFrame.text = _G["lookAndFeelBorderFrameText"]
lookAndFeelBorderFrame.text:SetText("HideBorders")

local lookAndFeelFixedPosition = CreateFrame("CheckButton","lookAndFeelFixedPosition",MyAddon.lookAndFeelPanel,"UICheckButtonTemplate")
lookAndFeelFixedPosition:SetPoint("TOPLEFT",5,-40)
lookAndFeelFixedPosition.text = _G["lookAndFeelFixedPositionText"]
lookAndFeelFixedPosition.text:SetText("Fixed frame positions")

local lookAndFeelHideCastWarning = CreateFrame("CheckButton","lookAndFeelHideCastWarning",MyAddon.lookAndFeelPanel,"UICheckButtonTemplate")
lookAndFeelHideCastWarning:SetPoint("TOPLEFT",5,-70)
lookAndFeelHideCastWarning.text = _G["lookAndFeelHideCastWarningText"]
lookAndFeelHideCastWarning.text:SetText("Hide cast warning")

local lookAndFeelHideBags = CreateFrame("CheckButton","lookAndFeelHideBags",MyAddon.lookAndFeelPanel,"UICheckButtonTemplate")
lookAndFeelHideBags:SetPoint("TOPLEFT",5,-100)
lookAndFeelHideBags.text = _G["lookAndFeelHideBagsText"]
lookAndFeelHideBags.text:SetText("Hide bags")

local lookAndFeelHideStance = CreateFrame("CheckButton","lookAndFeelHideStance",MyAddon.lookAndFeelPanel,"UICheckButtonTemplate")
lookAndFeelHideStance:SetPoint("TOPLEFT",5,-130)
lookAndFeelHideStance.text = _G["lookAndFeelHideStanceText"]
lookAndFeelHideStance.text:SetText("Hide stanceframe")

local lookAndFeelIconSize = CreateFrame("Slider","Icon size",MyAddon.lookAndFeelPanel,"OptionsSliderTemplate")
lookAndFeelIconSize:SetPoint("TOPLEFT",5,-170)
lookAndFeelIconSize.textLow = _G["Icon size" .."Low"]
lookAndFeelIconSize.textHigh = _G["Icon size" .."High"]
lookAndFeelIconSize.text = _G["Icon size" .."Text"]
lookAndFeelIconSize:SetMinMaxValues(1, 100)
lookAndFeelIconSize.minValue, lookAndFeelIconSize.maxValue = lookAndFeelIconSize:GetMinMaxValues()
lookAndFeelIconSize.textLow:SetText(lookAndFeelIconSize.minValue)
lookAndFeelIconSize.textHigh:SetText(lookAndFeelIconSize.maxValue)
lookAndFeelIconSize.text:SetText("Icon size")
lookAndFeelIconSize:SetValue(30)
lookAndFeelIconSize:SetValueStep(1)

local lookAndFeelFontIconSize = CreateFrame("Slider","Font Icon size",MyAddon.lookAndFeelPanel,"OptionsSliderTemplate")
lookAndFeelFontIconSize:SetPoint("TOPLEFT",5,-210)
lookAndFeelFontIconSize.textLow = _G["Font Icon size".."Low"]
lookAndFeelFontIconSize.textHigh = _G["Font Icon size".."High"]
lookAndFeelFontIconSize.text = _G["Font Icon size".."Text"]
lookAndFeelFontIconSize:SetMinMaxValues(1, 32)
lookAndFeelFontIconSize.minValue, lookAndFeelFontIconSize.maxValue = lookAndFeelFontIconSize:GetMinMaxValues()
lookAndFeelFontIconSize.textLow:SetText(lookAndFeelFontIconSize.minValue)
lookAndFeelFontIconSize.textHigh:SetText(lookAndFeelFontIconSize.maxValue)
lookAndFeelFontIconSize.text:SetText("Font Icon size")
lookAndFeelFontIconSize:SetValue(10)
lookAndFeelFontIconSize:SetValueStep(1)

local function setBorderAndBackgroundOfFrame(frame,backgroundImage,edgeImage)
	frame:SetBackdrop({
      		bgFile=backgroundImage, 
      		edgeFile=edgeImage, 
      		tile=1, tileSize=32, edgeSize=15, 
      		insets={left=0, right=0, top=0, bottom=0}
	})
end

local function setFrameSize(frame,w,h)
	frame:SetWidth(w)
	frame:SetHeight(h)
end

local function lookAndFeelChanged()
	-- DEFAULT_CHAT_FRAME:AddMessage( "lookAndFeelChanged" )
	width = lookAndFeelIconSize:GetValue()
	height = lookAndFeelIconSize:GetValue()
	iconFontSize = lookAndFeelFontIconSize:GetValue()

	setFrameSize(dynamicBuffFrame,(6*width)+10,(height)+10)
	setFrameSize(dynamicDebuffFrame,(6*width)+10,(height)+10)

	buff1Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")
	buff2Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")
	buff3Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")
	buff4Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")
	buff5Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")
	buff6Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")

	debuff1Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")
	debuff2Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")
	debuff3Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")
	debuff4Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")
	debuff5Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")
	debuff6Icon.text:SetFont("Fonts\\FRIZQT__.TTF", iconFontSize, "OUTLINE")
		
	buff1Icon:SetWidth(width)
	buff1Icon:SetHeight(height)
	buff2Icon:SetWidth(width)
	buff2Icon:SetHeight(height)
	buff3Icon:SetWidth(width)
	buff3Icon:SetHeight(height)
	buff4Icon:SetWidth(width)
	buff4Icon:SetHeight(height)
	buff5Icon:SetWidth(width)
	buff5Icon:SetHeight(height)
	buff6Icon:SetWidth(width)
	buff6Icon:SetHeight(height)

	debuff1Icon:SetWidth(width)
	debuff1Icon:SetHeight(height)
	debuff2Icon:SetWidth(width)
	debuff2Icon:SetHeight(height)
	debuff3Icon:SetWidth(width)
	debuff3Icon:SetHeight(height)
	debuff4Icon:SetWidth(width)
	debuff4Icon:SetHeight(height)
	debuff5Icon:SetWidth(width)
	debuff5Icon:SetHeight(height)
	debuff6Icon:SetWidth(width)
	debuff6Icon:SetHeight(height)

	local positionWith = 5

	buff1Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
	debuff1Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)

	positionWith = positionWith + width

	buff2Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
	debuff2Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)

	positionWith = positionWith + width

	buff3Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
	debuff3Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)

	positionWith = positionWith + width

	buff4Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
	debuff4Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)

	positionWith = positionWith + width

	buff5Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
	debuff5Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)

	positionWith = positionWith + width

	buff6Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
	debuff6Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)

	positionWith = positionWith + width


	if lookAndFeelFixedPosition:GetChecked() then
		dynamicBuffFrame:EnableMouse(false)
		dynamicDebuffFrame:EnableMouse(false)
		statusbarFrame:EnableMouse(false)
		castbarFrame:EnableMouse(false)
		resolve_frame:EnableMouse(false)
	else
		dynamicBuffFrame:EnableMouse(true)
		dynamicDebuffFrame:EnableMouse(true)
		statusbarFrame:EnableMouse(true)
		castbarFrame:EnableMouse(true)
		resolve_frame:EnableMouse(true)
	end
	if lookAndFeelBorderFrame:GetChecked() then
		setBorderAndBackgroundOfFrame(dynamicBuffFrame,"","")
		setBorderAndBackgroundOfFrame(dynamicDebuffFrame,"","")
		setBorderAndBackgroundOfFrame(statusbarFrame,"","")
		setBorderAndBackgroundOfFrame(castbarFrame,"","")
		castbarFrame:Hide()
	else
		setBorderAndBackgroundOfFrame(dynamicBuffFrame,"Interface\\DialogFrame\\UI-DialogBox-Background","Interface\\DialogFrame\\UI-DialogBox-Border")
		setBorderAndBackgroundOfFrame(dynamicDebuffFrame,"Interface\\DialogFrame\\UI-DialogBox-Background","Interface\\DialogFrame\\UI-DialogBox-Border")
		setBorderAndBackgroundOfFrame(statusbarFrame,"Interface\\DialogFrame\\UI-DialogBox-Background","Interface\\DialogFrame\\UI-DialogBox-Border")
		setBorderAndBackgroundOfFrame(castbarFrame,"Interface\\DialogFrame\\UI-DialogBox-Background","Interface\\DialogFrame\\UI-DialogBox-Border")
		castbarFrame:Show()
	end
	if lookAndFeelHideCastWarning:GetChecked() then
		castbarFrame:Hide()
	end
	if lookAndFeelHideBags:GetChecked() then
		if bagFrame ~= nil then
			bagFrame:Hide()
		end
	else
		if bagFrame ~= nil then
			bagFrame:Show()
		end
	end
	if lookAndFeelHideStance:GetChecked() then
		if stanceFrame ~= nil then
			UnregisterStateDriver(stanceFrame, "visibility")
			stanceFrame:Hide()
		end
	else
		if stanceFrame ~= nil then
			RegisterStateDriver(stanceFrame, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")
			stanceFrame:Show()
		end
	end
	if currentSelectedRessource0 == "Health" then
		ressourceBar0.value:SetTextColor(0, 1, 0)
		ressourceBar0:SetStatusBarColor(0, 1, 0)
		ressourceBar0.bg:SetVertexColor(0, 0.65, 0)
	elseif currentSelectedRessource0 == "Mana" then
		ressourceBar0.value:SetTextColor(0, 0.25, 1)
		ressourceBar0:SetStatusBarColor(0, 0.25, 1)
		ressourceBar0.bg:SetVertexColor(0, 0.125, 0.65)
	elseif currentSelectedRessource0 == "Rage" then
		ressourceBar0.value:SetTextColor(1, 0, 0)
		ressourceBar0:SetStatusBarColor(1, 0, 0)
		ressourceBar0.bg:SetVertexColor(0.65, 0, 0)
	elseif currentSelectedRessource0 == "Focus" then
		ressourceBar0.value:SetTextColor(1, 0.5, 0)
		ressourceBar0:SetStatusBarColor(1, 0.5, 0)
		ressourceBar0.bg:SetVertexColor(0.65, 0.325, 0)
	elseif currentSelectedRessource0 == "Energy" then
		ressourceBar0.value:SetTextColor(1, 1, 0)
		ressourceBar0:SetStatusBarColor(1, 1, 0)
		ressourceBar0.bg:SetVertexColor(0.65, 0.65, 0)
	elseif currentSelectedRessource0 == "Runic Power" then
		ressourceBar0.value:SetTextColor(0, 1, 1)
		ressourceBar0:SetStatusBarColor(0, 1, 1)
		ressourceBar0.bg:SetVertexColor(0, 0.65, 0.65)
	elseif currentSelectedRessource0 == "Soul Shards" then
		ressourceBar0.value:SetTextColor(1, 0, 1)
		ressourceBar0:SetStatusBarColor(1, 0, 1)
		ressourceBar0.bg:SetVertexColor(0.65, 0, 0.65)
	elseif currentSelectedRessource0 == "Holy Power" then
		ressourceBar0.value:SetTextColor(1, 1, 0)
		ressourceBar0:SetStatusBarColor(1, 1, 0)
		ressourceBar0.bg:SetVertexColor(0.65, 0.65, 0)
	elseif currentSelectedRessource0 == "Chi" then
		ressourceBar0.value:SetTextColor(0, 1, 1)
		ressourceBar0:SetStatusBarColor(0, 1, 1)
		ressourceBar0.bg:SetVertexColor(0, 0.65, 0.65)
	elseif currentSelectedRessource0 == "Shadow Orbs" then
		ressourceBar0.value:SetTextColor(1, 0, 1)
		ressourceBar0:SetStatusBarColor(1, 0, 1)
		ressourceBar0.bg:SetVertexColor(0.65, 0, 0.65)
	elseif currentSelectedRessource0 == "Burning Embers" then
		ressourceBar0.value:SetTextColor(1, 0, 0)
		ressourceBar0:SetStatusBarColor(1, 0, 0)
		ressourceBar0.bg:SetVertexColor(0.65, 0, 0)
	elseif currentSelectedRessource0 == "Demonic Fury" then
		ressourceBar0.value:SetTextColor(1, 0, 1)
		ressourceBar0:SetStatusBarColor(1, 0, 1)
		ressourceBar0.bg:SetVertexColor(0.65, 0, 0.65)
	elseif currentSelectedRessource0 == "Stagger" then
		ressourceBar0.value:SetTextColor(0, 1, 0)
		ressourceBar0:SetStatusBarColor(0, 1, 0)
		ressourceBar0.bg:SetVertexColor(0, 0.65, 0)
	end
	if currentSelectedRessource1 == "Health" then
		ressourceBar1.value:SetTextColor(0, 1, 0)
		ressourceBar1:SetStatusBarColor(0, 1, 0)
		ressourceBar1.bg:SetVertexColor(0, 0.65, 0)
	elseif currentSelectedRessource1 == "Mana" then
		ressourceBar1.value:SetTextColor(0, 0.25, 1)
		ressourceBar1:SetStatusBarColor(0, 0.25, 1)
		ressourceBar1.bg:SetVertexColor(0, 0.125, 0.65)
	elseif currentSelectedRessource1 == "Rage" then
		ressourceBar1.value:SetTextColor(1, 0, 0)
		ressourceBar1:SetStatusBarColor(1, 0, 0)
		ressourceBar1.bg:SetVertexColor(0.65, 0, 0)
	elseif currentSelectedRessource1 == "Focus" then
		ressourceBar1.value:SetTextColor(1, 0.5, 0)
		ressourceBar1:SetStatusBarColor(1, 0.5, 0)
		ressourceBar1.bg:SetVertexColor(0.65, 0.325, 0)
	elseif currentSelectedRessource1 == "Energy" then
		ressourceBar1.value:SetTextColor(1, 1, 0)
		ressourceBar1:SetStatusBarColor(1, 1, 0)
		ressourceBar1.bg:SetVertexColor(0.65, 0.65, 0)
	elseif currentSelectedRessource1 == "Runic Power" then
		ressourceBar1.value:SetTextColor(0, 1, 1)
		ressourceBar1:SetStatusBarColor(0, 1, 1)
		ressourceBar1.bg:SetVertexColor(0, 0.65, 0.65)
	elseif currentSelectedRessource1 == "Soul Shards" then
		ressourceBar1.value:SetTextColor(1, 0, 1)
		ressourceBar1:SetStatusBarColor(1, 0, 1)
		ressourceBar1.bg:SetVertexColor(0.65, 0, 0.65)
	elseif currentSelectedRessource1 == "Holy Power" then
		ressourceBar1.value:SetTextColor(1, 1, 0)
		ressourceBar1:SetStatusBarColor(1, 1, 0)
		ressourceBar1.bg:SetVertexColor(0.65, 0.65, 0)
	elseif currentSelectedRessource1 == "Chi" then
		ressourceBar1.value:SetTextColor(0, 1, 1)
		ressourceBar1:SetStatusBarColor(0, 1, 1)
		ressourceBar1.bg:SetVertexColor(0, 0.65, 0.65)
	elseif currentSelectedRessource1 == "Shadow Orbs" then
		ressourceBar1.value:SetTextColor(1, 0, 1)
		ressourceBar1:SetStatusBarColor(1, 0, 1)
		ressourceBar1.bg:SetVertexColor(0.65, 0, 0.65)
	elseif currentSelectedRessource1 == "Burning Embers" then
		ressourceBar1.value:SetTextColor(1, 0, 0)
		ressourceBar1:SetStatusBarColor(1, 0, 0)
		ressourceBar1.bg:SetVertexColor(0.65, 0, 0)
	elseif currentSelectedRessource1 == "Demonic Fury" then
		ressourceBar1.value:SetTextColor(1, 0, 1)
		ressourceBar1:SetStatusBarColor(1, 0, 1)
		ressourceBar1.bg:SetVertexColor(0.65, 0, 0.65)
	elseif currentSelectedRessource1 == "Stagger" then
		ressourceBar1.value:SetTextColor(0, 1, 0)
		ressourceBar1:SetStatusBarColor(0, 1, 0)
		ressourceBar1.bg:SetVertexColor(0, 0.65, 0)
	end
	if currentSelectedRessource2 == "Health" then
		ressourceBar2.value:SetTextColor(0, 1, 0)
		ressourceBar2:SetStatusBarColor(0, 1, 0)
		ressourceBar2.bg:SetVertexColor(0, 0.65, 0)
	elseif currentSelectedRessource2 == "Mana" then
		ressourceBar2.value:SetTextColor(0, 0.25, 1)
		ressourceBar2:SetStatusBarColor(0, 0.25, 1)
		ressourceBar2.bg:SetVertexColor(0, 0.125, 0.65)
	elseif currentSelectedRessource2 == "Rage" then
		ressourceBar2.value:SetTextColor(1, 0, 0)
		ressourceBar2:SetStatusBarColor(1, 0, 0)
		ressourceBar2.bg:SetVertexColor(0.65, 0, 0)
	elseif currentSelectedRessource2 == "Focus" then
		ressourceBar2.value:SetTextColor(1, 0.5, 0)
		ressourceBar2:SetStatusBarColor(1, 0.5, 0)
		ressourceBar2.bg:SetVertexColor(0.65, 0.325, 0)
	elseif currentSelectedRessource2 == "Energy" then
		ressourceBar2.value:SetTextColor(1, 1, 0)
		ressourceBar2:SetStatusBarColor(1, 1, 0)
		ressourceBar2.bg:SetVertexColor(0.65, 0.65, 0)
	elseif currentSelectedRessource2 == "Runic Power" then
		ressourceBar2.value:SetTextColor(0, 1, 1)
		ressourceBar2:SetStatusBarColor(0, 1, 1)
		ressourceBar2.bg:SetVertexColor(0, 0.65, 0.65)
	elseif currentSelectedRessource2 == "Soul Shards" then
		ressourceBar2.value:SetTextColor(1, 0, 1)
		ressourceBar2:SetStatusBarColor(1, 0, 1)
		ressourceBar2.bg:SetVertexColor(0.65, 0, 0.65)
	elseif currentSelectedRessource2 == "Holy Power" then
		ressourceBar2.value:SetTextColor(1, 1, 0)
		ressourceBar2:SetStatusBarColor(1, 1, 0)
		ressourceBar2.bg:SetVertexColor(0.65, 0.65, 0)
	elseif currentSelectedRessource2 == "Chi" then
		ressourceBar2.value:SetTextColor(0, 1, 1)
		ressourceBar2:SetStatusBarColor(0, 1, 1)
		ressourceBar2.bg:SetVertexColor(0, 0.65, 0.65)
	elseif currentSelectedRessource2 == "Shadow Orbs" then
		ressourceBar2.value:SetTextColor(1, 0, 1)
		ressourceBar2:SetStatusBarColor(1, 0, 1)
		ressourceBar2.bg:SetVertexColor(0.65, 0, 0.65)
	elseif currentSelectedRessource2 == "Burning Embers" then
		ressourceBar2.value:SetTextColor(1, 0, 0)
		ressourceBar2:SetStatusBarColor(1, 0, 0)
		ressourceBar2.bg:SetVertexColor(0.65, 0, 0)
	elseif currentSelectedRessource2 == "Demonic Fury" then
		ressourceBar2.value:SetTextColor(1, 0, 1)
		ressourceBar2:SetStatusBarColor(1, 0, 1)
		ressourceBar2.bg:SetVertexColor(0.65, 0, 0.65)
	elseif currentSelectedRessource2 == "Stagger" then
		ressourceBar2.value:SetTextColor(0, 1, 0)
		ressourceBar2:SetStatusBarColor(0, 1, 0)
		ressourceBar2.bg:SetVertexColor(0, 0.65, 0)
	end
	saveAddon()
end

lookAndFeelBorderFrame:SetScript("OnClick", function(self,event,arg1)
	lookAndFeelChanged()
end)

lookAndFeelFixedPosition:SetScript("OnClick", function(self,event,arg1)
	lookAndFeelChanged()
end)

lookAndFeelHideCastWarning:SetScript("OnClick", function(self,event,arg1)
	lookAndFeelChanged()
end)

lookAndFeelHideBags:SetScript("OnClick", function(self,event,arg1)
	lookAndFeelChanged()
end)

lookAndFeelHideStance:SetScript("OnClick", function(self,event,arg1)
	lookAndFeelChanged()
end)

lookAndFeelIconSize:SetScript("OnValueChanged", function(self,event,arg1)
	lookAndFeelChanged()
end)

lookAndFeelFontIconSize:SetScript("OnValueChanged", function(self,event,arg1)
	lookAndFeelChanged()
end)

useBrewmasterLookAndFeelConfig:SetScript("OnClick", function(self,event,arg1)
	lookAndFeelChanged()
end)

InterfaceOptions_AddCategory(MyAddon.lookAndFeelPanel);

MyAddon.buffschildpanel = CreateFrame( "Frame", "buffschildpanel", MyAddon.panel);
MyAddon.buffschildpanel.name = "Buffs";
MyAddon.buffschildpanel.parent = MyAddon.panel.name;

InterfaceOptions_AddCategory(MyAddon.buffschildpanel);

local buff1 = CreateFrame("EditBox", "buffEB1", MyAddon.buffschildpanel, "InputBoxTemplate")
buff1:SetWidth(250)
buff1:SetHeight(20)
buff1:SetPoint("TOPLEFT", 10, -10)
buff1:SetAutoFocus(false)
buff1:SetText("115307")
buff1:SetCursorPosition(0)
buff1:Show()
buff1.text = buff1:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff1.text:SetPoint("RIGHT", 0, 0)
buff1.text:SetText("Buff1 (115307)");
buff1.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

local buff2 = CreateFrame("EditBox", "buffEB2", MyAddon.buffschildpanel, "InputBoxTemplate")
buff2:SetWidth(250)
buff2:SetHeight(20)
buff2:SetPoint("TOPLEFT", 10, -40)
buff2:SetAutoFocus(false)
buff2:SetText("128939")
buff2:SetCursorPosition(0)
buff2:Show()
buff2.text = buff2:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff2.text:SetPoint("RIGHT", 0, 0)
buff2.text:SetText("Buff2 (128939)");
buff2.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

local buff3 = CreateFrame("EditBox", "buffEB3", MyAddon.buffschildpanel, "InputBoxTemplate")
buff3:SetWidth(250)
buff3:SetHeight(20)
buff3:SetPoint("TOPLEFT", 10, -70)
buff3:SetAutoFocus(false)
buff3:SetText("115308")
buff3:SetCursorPosition(0)
buff3:Show()
buff3.text = buff3:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff3.text:SetPoint("RIGHT", 0, 0)
buff3.text:SetText("Buff3 (115308)");
buff3.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")


local buff4 = CreateFrame("EditBox", "buffEB4", MyAddon.buffschildpanel, "InputBoxTemplate")
buff4:SetWidth(250)
buff4:SetHeight(20)
buff4:SetPoint("TOPLEFT", 10, -100)
buff4:SetAutoFocus(false)
buff4:SetText("115295")
buff4:SetCursorPosition(0)
buff4:Show()
buff4.text = buff4:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff4.text:SetPoint("RIGHT", 0, 0)
buff4.text:SetText("Buff4 (115295)");
buff4.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

local buff5 = CreateFrame("EditBox", "buffEB5", MyAddon.buffschildpanel, "InputBoxTemplate")
buff5:SetWidth(250)
buff5:SetHeight(20)
buff5:SetPoint("TOPLEFT", 10, -130)
buff5:SetAutoFocus(false)
buff5:SetText("122278")
buff5:SetCursorPosition(0)
buff5:Show()
buff5.text = buff5:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff5.text:SetPoint("RIGHT", 0, 0)
buff5.text:SetText("Buff5 (122278)");
buff5.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

local buff6 = CreateFrame("EditBox", "buffEB6", MyAddon.buffschildpanel, "InputBoxTemplate")
buff6:SetWidth(250)
buff6:SetHeight(20)
buff6:SetPoint("TOPLEFT", 10, -160)
buff6:SetAutoFocus(false)
buff6:SetText("120954")
buff6:SetCursorPosition(0)
buff6:Show()
buff6.text = buff6:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff6.text:SetPoint("RIGHT", 0, 0)
buff6.text:SetText("Buff6 (120954)");
buff6.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

MyAddon.debuffschildpanel = CreateFrame( "Frame", "debuffschildpanel", MyAddon.panel);
MyAddon.debuffschildpanel.name = "Debuffs";
MyAddon.debuffschildpanel.parent = MyAddon.panel.name;

InterfaceOptions_AddCategory(MyAddon.debuffschildpanel);

local debuff1 = CreateFrame("EditBox", "debuffEB1", MyAddon.debuffschildpanel, "InputBoxTemplate")
debuff1:SetWidth(250)
debuff1:SetHeight(20)
debuff1:SetPoint("TOPLEFT", 10, -10)
debuff1:SetAutoFocus(false)
debuff1:SetText("124275")
debuff1:SetCursorPosition(0)
debuff1:Show()
debuff1.text = debuff1:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff1.text:SetPoint("RIGHT", 0, 0)
debuff1.text:SetText("Debuff1 (124275)");
debuff1.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

local debuff2 = CreateFrame("EditBox", "debuffEB2", MyAddon.debuffschildpanel, "InputBoxTemplate")
debuff2:SetWidth(250)
debuff2:SetHeight(20)
debuff2:SetPoint("TOPLEFT", 10, -40)
debuff2:SetAutoFocus(false)
debuff2:SetText("124274")
debuff2:SetCursorPosition(0)
debuff2:Show()
debuff2.text = debuff2:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff2.text:SetPoint("RIGHT", 0, 0)
debuff2.text:SetText("Debuff2 (124274)");
debuff2.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

local debuff3 = CreateFrame("EditBox", "debuffEB3", MyAddon.debuffschildpanel, "InputBoxTemplate")
debuff3:SetWidth(250)
debuff3:SetHeight(20)
debuff3:SetPoint("TOPLEFT", 10, -70)
debuff3:SetAutoFocus(false)
debuff3:SetText("124273")
debuff3:SetCursorPosition(0)
debuff3:Show()
debuff3.text = debuff3:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff3.text:SetPoint("RIGHT", 0, 0)
debuff3.text:SetText("Debuff3 (124273)");
debuff3.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

local debuff4 = CreateFrame("EditBox", "debuffEB4", MyAddon.debuffschildpanel, "InputBoxTemplate")
debuff4:SetWidth(250)
debuff4:SetHeight(20)
debuff4:SetPoint("TOPLEFT", 10, -100)
debuff4:SetAutoFocus(false)
debuff4:SetText("0")
debuff4:SetCursorPosition(0)
debuff4:Show()
debuff4.text = debuff4:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff4.text:SetPoint("RIGHT", 0, 0)
debuff4.text:SetText("Debuff4 (NOT SET)");
debuff4.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

local debuff5 = CreateFrame("EditBox", "debuffEB5", MyAddon.debuffschildpanel, "InputBoxTemplate")
debuff5:SetWidth(250)
debuff5:SetHeight(20)
debuff5:SetPoint("TOPLEFT", 10, -130)
debuff5:SetAutoFocus(false)
debuff5:SetText("0")
debuff5:SetCursorPosition(0)
debuff5:Show()
debuff5.text = debuff5:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff5.text:SetPoint("RIGHT", 0, 0)
debuff5.text:SetText("Debuff5 (NOT SET)");
debuff5.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

local debuff6 = CreateFrame("EditBox", "debuffEB6", MyAddon.debuffschildpanel, "InputBoxTemplate")
debuff6:SetWidth(250)
debuff6:SetHeight(20)
debuff6:SetPoint("TOPLEFT", 10, -160)
debuff6:SetAutoFocus(false)
debuff6:SetText("0")
debuff6:SetCursorPosition(0)
debuff6:Show()
debuff6.text = debuff6:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff6.text:SetPoint("RIGHT", 0, 0)
debuff6.text:SetText("Debuff6 (NOT SET)");
debuff6.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

local buffListGui=CreateFrame("Button", "buffListGui", MyAddon.buffschildpanel, "UIDropDownMenuTemplate")
buffListGui:SetPoint("TOPLEFT", 280, -40)
buffListGui:Show()

local function OnClick(self)
	UIDropDownMenu_SetSelectedID(buffListGui, self:GetID())
	for k,v in ipairs(bufflist) do
		if v.name == self.value then
			buff1:SetText(v.buff1)
			buff1:SetCursorPosition(0)
			buff2:SetText(v.buff2)
			buff2:SetCursorPosition(0)
			buff3:SetText(v.buff3)
			buff3:SetCursorPosition(0)
			buff4:SetText(v.buff4)
			buff4:SetCursorPosition(0)
			buff5:SetText(v.buff5)
			buff5:SetCursorPosition(0)
			buff6:SetText(v.buff6)
			buff6:SetCursorPosition(0)
		end
    	end
	saveAddon()
end

local function initialize(self, level)
	local info=UIDropDownMenu_CreateInfo()
	for k,v in ipairs(bufflist) do
		info=UIDropDownMenu_CreateInfo()
		info.text=v.name
		info.value=v.name
		info.func=OnClick
		UIDropDownMenu_AddButton(info, level)
    	end
end

local function Init(btn)
	UIDropDownMenu_Initialize(btn, initialize)
	UIDropDownMenu_SetWidth(btn, 120)
	UIDropDownMenu_SetButtonWidth(btn, 124)
	UIDropDownMenu_SetSelectedID(btn, 1)
	UIDropDownMenu_JustifyText(btn, "LEFT")
end

local buffsetName = CreateFrame("EditBox", "buffsetName", MyAddon.buffschildpanel, "InputBoxTemplate")
buffsetName:SetWidth(190)
buffsetName:SetHeight(20)
buffsetName:SetPoint("TOPLEFT", 300, -10)
buffsetName:SetAutoFocus(false)
buffsetName:SetText("0")
buffsetName:SetCursorPosition(0)
buffsetName:Show()
buffsetName.text = buffsetName:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buffsetName.text:SetPoint("RIGHT", 0, 0)
buffsetName.text:SetText("");
buffsetName.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")
    
local addBuffSet = CreateFrame("Button","addBuffSet",MyAddon.buffschildpanel,"UIPanelButtonTemplate")
addBuffSet:SetSize(100,20)
addBuffSet:SetPoint("TOPLEFT", 500, -10)
addBuffSet.text = _G["addBuffSetText"]
addBuffSet.text:SetText("Add")
addBuffSet:SetScript("OnClick", function()
	local buffset = {name = buffsetName:GetText() , buff1 = buff1:GetText(), buff2 = buff2:GetText(), buff3 = buff3:GetText(), buff4 = buff4:GetText(), buff5 = buff5:GetText(), buff6 = buff6:GetText()};
	table.insert(bufflist, buffset)
	sort(bufflist, function(a,b) return a.name < b.name end)
	Init(buffListGui)
	saveAddon()
end)

local removeBuffSet = CreateFrame("Button","removeBuffSet",MyAddon.buffschildpanel,"UIPanelButtonTemplate")
removeBuffSet:SetSize(100,20)
removeBuffSet:SetPoint("TOPLEFT", 500, -40)
removeBuffSet.text = _G["removeBuffSetText"]
removeBuffSet.text:SetText("Remove")
removeBuffSet:SetScript("OnClick", function()
	local info = UIDropDownMenu_GetText(buffListGui)
	if info ~= nil then
		local buffsetkey
		for k,v in ipairs(bufflist) do
			if v.name == info then
				buffsetkey = k
			end
	    	end
		if buffsetkey ~= nil then
			table.remove(bufflist, buffsetkey)
			sort(bufflist, function(a,b) return a.name < b.name end)
			Init(buffListGui)
		end
	end
	saveAddon()
end)

local automaticDebuffCheckFrame = CreateFrame("CheckButton","automaticDebuffCheckFrame",MyAddon.debuffschildpanel,"UICheckButtonTemplate")
automaticDebuffCheckFrame:SetPoint("TOPLEFT",500,-70)
automaticDebuffCheckFrame.text = _G["automaticDebuffCheckFrameText"]
automaticDebuffCheckFrame.text:SetText("Automatic")

automaticDebuffCheckFrame:SetScript("OnClick", function(self,event,arg1)
	lookAndFeelChanged()
end)

-----------------------------------

local ressourceBar0ListGui=CreateFrame("Button", "ressourceBar0ListGui", MyAddon.lookAndFeelPanel, "UIDropDownMenuTemplate")
ressourceBar0ListGui:SetPoint("TOPLEFT", 5, -240)
ressourceBar0ListGui:Show()

local function ressourceBar0OnClick(self)
	UIDropDownMenu_SetSelectedID(ressourceBar0ListGui, self:GetID())
	currentSelectedRessource0 = self.value
	lookAndFeelChanged()
end

local function ressourceBar0initialize(self, level)
	local info=UIDropDownMenu_CreateInfo()
	info.text="---"
	info.value="---"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)
	
	info=UIDropDownMenu_CreateInfo()
	info.text="Health"
	info.value="Health"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Mana"
	info.value="Mana"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Rage"
	info.value="Rage"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Focus"
	info.value="Focus"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Energy"
	info.value="Energy"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Runic Power"
	info.value="Runic Power"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Soul Shards"
	info.value="Soul Shards"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Holy Power"
	info.value="Holy Power"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Chi"
	info.value="Chi"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Shadow Orbs"
	info.value="Shadow Orbs"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Burning Embers"
	info.value="Burning Embers"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Demonic Fury"
	info.value="Demonic Fury"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Stagger"
	info.value="Stagger"
	info.func=ressourceBar0OnClick
	UIDropDownMenu_AddButton(info, level)
end

local function ressourceBar0Init(btn)
	UIDropDownMenu_Initialize(btn, ressourceBar0initialize)
	UIDropDownMenu_SetWidth(btn, 120)
	UIDropDownMenu_SetButtonWidth(btn, 124)
	UIDropDownMenu_SetSelectedID(btn, 1)
	UIDropDownMenu_JustifyText(btn, "LEFT")
end

ressourceBar0Init(ressourceBar0ListGui)

-----------------------

local ressourceBar1ListGui=CreateFrame("Button", "ressourceBar1ListGui", MyAddon.lookAndFeelPanel, "UIDropDownMenuTemplate")
ressourceBar1ListGui:SetPoint("TOPLEFT", 5, -270)
ressourceBar1ListGui:Show()

local function ressourceBar1OnClick(self)
	UIDropDownMenu_SetSelectedID(ressourceBar1ListGui, self:GetID())
	currentSelectedRessource1 = self.value
	lookAndFeelChanged()
end

local function ressourceBar1initialize(self, level)
	local info=UIDropDownMenu_CreateInfo()
	info.text="---"
	info.value="---"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Health"
	info.value="Health"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Mana"
	info.value="Mana"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Rage"
	info.value="Rage"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Focus"
	info.value="Focus"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Energy"
	info.value="Energy"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Runic Power"
	info.value="Runic Power"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Soul Shards"
	info.value="Soul Shards"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Holy Power"
	info.value="Holy Power"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Chi"
	info.value="Chi"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Shadow Orbs"
	info.value="Shadow Orbs"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Burning Embers"
	info.value="Burning Embers"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Demonic Fury"
	info.value="Demonic Fury"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Stagger"
	info.value="Stagger"
	info.func=ressourceBar1OnClick
	UIDropDownMenu_AddButton(info, level)
end

local function ressourceBar1Init(btn)
	UIDropDownMenu_Initialize(btn, ressourceBar1initialize)
	UIDropDownMenu_SetWidth(btn, 120)
	UIDropDownMenu_SetButtonWidth(btn, 124)
	UIDropDownMenu_SetSelectedID(btn, 1)
	UIDropDownMenu_JustifyText(btn, "LEFT")
end

ressourceBar1Init(ressourceBar1ListGui)

-----------------------

local ressourceBar2ListGui=CreateFrame("Button", "ressourceBar2ListGui", MyAddon.lookAndFeelPanel, "UIDropDownMenuTemplate")
ressourceBar2ListGui:SetPoint("TOPLEFT", 5, -300)
ressourceBar2ListGui:Show()

local function ressourceBar2OnClick(self)
	UIDropDownMenu_SetSelectedID(ressourceBar2ListGui, self:GetID())
	currentSelectedRessource2 = self.value
	lookAndFeelChanged()
end

local function ressourceBar2initialize(self, level)
	local info=UIDropDownMenu_CreateInfo()
	info.text="---"
	info.value="---"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Health"
	info.value="Health"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Mana"
	info.value="Mana"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Rage"
	info.value="Rage"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Focus"
	info.value="Focus"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Energy"
	info.value="Energy"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Runic Power"
	info.value="Runic Power"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Soul Shards"
	info.value="Soul Shards"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Holy Power"
	info.value="Holy Power"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Chi"
	info.value="Chi"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Shadow Orbs"
	info.value="Shadow Orbs"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Burning Embers"
	info.value="Burning Embers"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Demonic Fury"
	info.value="Demonic Fury"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)

	info=UIDropDownMenu_CreateInfo()
	info.text="Stagger"
	info.value="Stagger"
	info.func=ressourceBar2OnClick
	UIDropDownMenu_AddButton(info, level)
end

local function ressourceBar2Init(btn)
	UIDropDownMenu_Initialize(btn, ressourceBar2initialize)
	UIDropDownMenu_SetWidth(btn, 120)
	UIDropDownMenu_SetButtonWidth(btn, 124)
	UIDropDownMenu_SetSelectedID(btn, 1)
	UIDropDownMenu_JustifyText(btn, "LEFT")
end

ressourceBar2Init(ressourceBar2ListGui)

-----------------------

local debuffListGui=CreateFrame("Button", "debuffListGui", MyAddon.debuffschildpanel, "UIDropDownMenuTemplate")
debuffListGui:SetPoint("TOPLEFT", 280, -40)
debuffListGui:Show()

local function deOnClick(self)
	UIDropDownMenu_SetSelectedID(debuffListGui, self:GetID())
	for k,v in ipairs(debufflist) do
		if v.name == self.value then
			debuff1:SetText(v.debuff1)
			debuff1:SetCursorPosition(0)
			debuff2:SetText(v.debuff2)
			debuff2:SetCursorPosition(0)
			debuff3:SetText(v.debuff3)
			debuff3:SetCursorPosition(0)
			debuff4:SetText(v.debuff4)
			debuff4:SetCursorPosition(0)
			debuff5:SetText(v.debuff5)
			debuff5:SetCursorPosition(0)
			debuff6:SetText(v.debuff6)
			debuff6:SetCursorPosition(0)
		end
    	end
	saveAddon()
end

local function debuffinitialize(self, level)
	local info=UIDropDownMenu_CreateInfo()
	for k,v in ipairs(debufflist) do
		info=UIDropDownMenu_CreateInfo()
		info.text=v.name
		info.value=v.name
		info.func=deOnClick
		UIDropDownMenu_AddButton(info, level)
    	end
end

local function debuffInit(btn)
	UIDropDownMenu_Initialize(btn, debuffinitialize)
	UIDropDownMenu_SetWidth(btn, 120)
	UIDropDownMenu_SetButtonWidth(btn, 124)
	UIDropDownMenu_SetSelectedID(btn, 1)
	UIDropDownMenu_JustifyText(btn, "LEFT")
end

local debuffsetName = CreateFrame("EditBox", "debuffsetName", MyAddon.debuffschildpanel, "InputBoxTemplate")
debuffsetName:SetWidth(190)
debuffsetName:SetHeight(20)
debuffsetName:SetPoint("TOPLEFT", 300, -10)
debuffsetName:SetAutoFocus(false)
debuffsetName:SetText("0")
debuffsetName:SetCursorPosition(0)
debuffsetName:Show()
debuffsetName.text = debuffsetName:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuffsetName.text:SetPoint("RIGHT", 0, 0)
debuffsetName.text:SetText("");
debuffsetName.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")
    
local adddeBuffSet = CreateFrame("Button","adddeBuffSet",MyAddon.debuffschildpanel,"UIPanelButtonTemplate")
adddeBuffSet:SetSize(100,20)
adddeBuffSet:SetPoint("TOPLEFT", 500, -10)
adddeBuffSet.text = _G["adddeBuffSetText"]
adddeBuffSet.text:SetText("Add")
adddeBuffSet:SetScript("OnClick", function()
	local buffset = {name = debuffsetName:GetText() , debuff1 = debuff1:GetText(), debuff2 = debuff2:GetText(), debuff3 = debuff3:GetText(), debuff4 = debuff4:GetText(), debuff5 = debuff5:GetText(), debuff6 = debuff6:GetText()};
	table.insert(debufflist, buffset)
	sort(debufflist, function(a,b) return a.name < b.name end)
	debuffInit(debuffListGui)
	saveAddon()
end)

local removedeBuffSet = CreateFrame("Button","removedeBuffSet",MyAddon.debuffschildpanel,"UIPanelButtonTemplate")
removedeBuffSet:SetSize(100,20)
removedeBuffSet:SetPoint("TOPLEFT", 500, -40)
removedeBuffSet.text = _G["removedeBuffSetText"]
removedeBuffSet.text:SetText("Remove")
removedeBuffSet:SetScript("OnClick", function()
	local info = UIDropDownMenu_GetText(debuffListGui)
	if info ~= nil then
		local debuffsetkey
		for k,v in ipairs(debufflist) do
			if v.name == info then
				debuffsetkey = k
			end
	    	end
		if debuffsetkey ~= nil then
			table.remove(debufflist, debuffsetkey)
			sort(debufflist, function(a,b) return a.name < b.name end)
			debuffInit(debuffListGui)
		end
	end
	saveAddon()
end)

-- CONFIG

name = UnitName("player")
print("Hello " .. name .. "! Welcme to brewmaster 1.0")

-------------------------------------------------------
-- Dynamic bar

if monk == true then
	currentSelectedRessource1 = "Stagger"
	currentSelectedRessource2 = "Chi"
elseif druid == true then
	currentSelectedRessource1 = "Rage"
	currentSelectedRessource2 = "---"
elseif deathknight == true then
	currentSelectedRessource1 = "Runic Power"
	currentSelectedRessource2 = "---"
elseif paladin == true then
	currentSelectedRessource1 = "Holy Power"
	currentSelectedRessource2 = "---"
elseif warrior == true then
	currentSelectedRessource1 = "Rage"
	currentSelectedRessource2 = "---"
end

--------------------------------------------------------
local positionWith = 5

buff1Icon:SetWidth(width)
buff1Icon:SetHeight(height)
buff1Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
local tbuff1Icon = buff1Icon:CreateTexture(nil,"BACKGROUND")
tbuff1Icon:SetAllPoints(buff1Icon)
buff1Icon.texture = tbuff1Icon
buff1Icon.text = buff1Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff1Icon.text:SetAllPoints();
buff1Icon.text:SetText("");
buff1Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

debuff1Icon:SetWidth(width)
debuff1Icon:SetHeight(height)
debuff1Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)
local tdebuff1Icon = debuff1Icon:CreateTexture(nil,"BACKGROUND")
tdebuff1Icon:SetAllPoints(debuff1Icon)
debuff1Icon.texture = tdebuff1Icon
debuff1Icon.text = debuff1Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff1Icon.text:SetAllPoints();
debuff1Icon.text:SetText("");
debuff1Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

positionWith = positionWith + width

buff2Icon:SetWidth(width)
buff2Icon:SetHeight(height)
buff2Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
local tbuff2Icon = buff2Icon:CreateTexture(nil,"BACKGROUND")
tbuff2Icon:SetAllPoints(buff2Icon)
buff2Icon.texture = tbuff2Icon
buff2Icon.text = buff2Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff2Icon.text:SetAllPoints();
buff2Icon.text:SetText("");
buff2Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

debuff2Icon:SetWidth(width)
debuff2Icon:SetHeight(height)
debuff2Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)
local tdebuff2Icon = debuff2Icon:CreateTexture(nil,"BACKGROUND")
tdebuff2Icon:SetAllPoints(debuff2Icon)
debuff2Icon.texture = tdebuff2Icon
debuff2Icon.text = debuff2Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff2Icon.text:SetAllPoints();
debuff2Icon.text:SetText("");
debuff2Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

positionWith = positionWith + width

buff3Icon:SetWidth(width)
buff3Icon:SetHeight(height)
buff3Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
local tbuff3Icon = buff3Icon:CreateTexture(nil,"BACKGROUND")
tbuff3Icon:SetAllPoints(buff3Icon)
buff3Icon.texture = tbuff3Icon
buff3Icon.text = buff3Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff3Icon.text:SetAllPoints();
buff3Icon.text:SetText("");
buff3Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

debuff3Icon:SetWidth(width)
debuff3Icon:SetHeight(height)
debuff3Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)
local tdebuff3Icon = debuff3Icon:CreateTexture(nil,"BACKGROUND")
tdebuff3Icon:SetAllPoints(debuff3Icon)
debuff3Icon.texture = tdebuff3Icon
debuff3Icon.text = debuff3Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff3Icon.text:SetAllPoints();
debuff3Icon.text:SetText("");
debuff3Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

positionWith = positionWith + width

buff4Icon:SetWidth(width)
buff4Icon:SetHeight(height)
buff4Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
local tbuff4Icon = buff4Icon:CreateTexture(nil,"BACKGROUND")
tbuff4Icon:SetAllPoints(buff4Icon)
buff4Icon.texture = tbuff4Icon
buff4Icon.text = buff4Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff4Icon.text:SetAllPoints();
buff4Icon.text:SetText("");
buff4Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

debuff4Icon:SetWidth(width)
debuff4Icon:SetHeight(height)
debuff4Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)
local tdebuff4Icon = debuff4Icon:CreateTexture(nil,"BACKGROUND")
tdebuff4Icon:SetAllPoints(debuff4Icon)
debuff4Icon.texture = tdebuff4Icon
debuff4Icon.text = debuff4Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff4Icon.text:SetAllPoints();
debuff4Icon.text:SetText("");
debuff4Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

positionWith = positionWith + width

buff5Icon:SetWidth(width)
buff5Icon:SetHeight(height)
buff5Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
local tbuff5Icon = buff5Icon:CreateTexture(nil,"BACKGROUND")
tbuff5Icon:SetAllPoints(buff5Icon)
buff5Icon.texture = tbuff5Icon
buff5Icon.text = buff5Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff5Icon.text:SetAllPoints();
buff5Icon.text:SetText("");
buff5Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

debuff5Icon:SetWidth(width)
debuff5Icon:SetHeight(height)
debuff5Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)
local tdebuff5Icon = debuff5Icon:CreateTexture(nil,"BACKGROUND")
tdebuff5Icon:SetAllPoints(debuff5Icon)
debuff5Icon.texture = tdebuff5Icon
debuff5Icon.text = debuff5Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff5Icon.text:SetAllPoints();
debuff5Icon.text:SetText("");
debuff5Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

positionWith = positionWith + width

buff6Icon:SetWidth(width)
buff6Icon:SetHeight(height)
buff6Icon:SetPoint("TOPLEFT",dynamicBuffFrame,positionWith,-5)
local tbuff6Icon = buff6Icon:CreateTexture(nil,"BACKGROUND")
tbuff6Icon:SetAllPoints(buff6Icon)
buff6Icon.texture = tbuff6Icon
buff6Icon.text = buff6Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
buff6Icon.text:SetAllPoints();
buff6Icon.text:SetText("");
buff6Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

debuff6Icon:SetWidth(width)
debuff6Icon:SetHeight(height)
debuff6Icon:SetPoint("TOPLEFT",dynamicDebuffFrame,positionWith,-5)
local tdebuff6Icon = debuff6Icon:CreateTexture(nil,"BACKGROUND")
tdebuff6Icon:SetAllPoints(debuff6Icon)
debuff6Icon.texture = tdebuff6Icon
debuff6Icon.text = debuff6Icon:CreateFontString(nil, "BACKGROUND", "NumberFont_Shadow_Small");
debuff6Icon.text:SetAllPoints();
debuff6Icon.text:SetText("");
debuff6Icon.text:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")

local function updateRessourceBar2(currentValue,maxValue,name)
	local percentage = 0
	if currentValue == 0 then
		percentage = 0
	elseif maxValue == 0 then
		percentage = 0
	else
		percentage = math.floor(( currentValue / maxValue ) * 100)
	end
	if name == "Stagger" then
		if percentage <= 30 then
			ressourceBar2.value:SetTextColor(0, 1, 0)
			ressourceBar2:SetStatusBarColor(0, 1, 0)
			ressourceBar2.bg:SetVertexColor(0, 0.65, 0)
		elseif percentage <= 60 then
			ressourceBar2.value:SetTextColor(1, 1, 0)
			ressourceBar2:SetStatusBarColor(1, 1, 0)
			ressourceBar2.bg:SetVertexColor(0.65, 0.65, 0)
		elseif percentage > 60 then
			ressourceBar2.value:SetTextColor(1, 0, 0)
			ressourceBar2:SetStatusBarColor(1, 0, 0)
			ressourceBar2.bg:SetVertexColor(0.65, 0, 0)
		end
	end
	if name == "Health" then
		if percentage >= 75 then
			ressourceBar2.value:SetTextColor(0, 1, 0)
			ressourceBar2:SetStatusBarColor(0, 1, 0)
			ressourceBar0.bg:SetVertexColor(0, 0.65, 0)
		elseif percentage >=50 then
			ressourceBar2.value:SetTextColor(1, 1, 0)
			ressourceBar2:SetStatusBarColor(1, 1, 0)
			ressourceBar2.bg:SetVertexColor(0.65, 0.65, 0)
		elseif percentage < 50 then
			ressourceBar2.value:SetTextColor(1, 0, 0)
			ressourceBar2:SetStatusBarColor(1, 0, 0)
			ressourceBar2.bg:SetVertexColor(0.65, 0, 0)
		end
	end
	ressourceBar2.value:SetText(percentage .. " % " .. name)
	ressourceBar2:SetValue(percentage)
end

local function updateRessourceBar1(currentValue,maxValue,name)
	local percentage = 0
	if currentValue == 0 then
		percentage = 0
	elseif maxValue == 0 then
		percentage = 0
	else
		percentage = math.floor(( currentValue / maxValue ) * 100)
	end
	if name == "Stagger" then
		if percentage <= 30 then
			ressourceBar1.value:SetTextColor(0, 1, 0)
			ressourceBar1:SetStatusBarColor(0, 1, 0)
			ressourceBar1.bg:SetVertexColor(0, 0.65, 0)
		elseif percentage <= 60 then
			ressourceBar1.value:SetTextColor(1, 1, 0)
			ressourceBar1:SetStatusBarColor(1, 1, 0)
			ressourceBar1.bg:SetVertexColor(0.65, 0.65, 0)
		elseif percentage > 60 then
			ressourceBar1.value:SetTextColor(1, 0, 0)
			ressourceBar1:SetStatusBarColor(1, 0, 0)
			ressourceBar1.bg:SetVertexColor(0.65, 0, 0)
		end
	end
	if name == "Health" then
		if percentage >= 75 then
			ressourceBar1.value:SetTextColor(0, 1, 0)
			ressourceBar1:SetStatusBarColor(0, 1, 0)
			ressourceBar1.bg:SetVertexColor(0, 0.65, 0)
		elseif percentage >=50 then
			ressourceBar1.value:SetTextColor(1, 1, 0)
			ressourceBar1:SetStatusBarColor(1, 1, 0)
			ressourceBar1.bg:SetVertexColor(0.65, 0.65, 0)
		elseif percentage < 50 then
			ressourceBar1.value:SetTextColor(1, 0, 0)
			ressourceBar1:SetStatusBarColor(1, 0, 0)
			ressourceBar1.bg:SetVertexColor(0.65, 0, 0)
		end
	end
	ressourceBar1.value:SetText(percentage .. " % " .. name)
	ressourceBar1:SetValue(percentage)
end

local function updateRessourceBar0(currentValue,maxValue,name)
	local percentage = 0
	if currentValue == 0 then
		percentage = 0
	elseif maxValue == 0 then
		percentage = 0
	else
		percentage = math.floor(( currentValue / maxValue ) * 100)
	end
	if name == "Stagger" then
		if percentage <= 30 then
			ressourceBar0.value:SetTextColor(0, 1, 0)
			ressourceBar0:SetStatusBarColor(0, 1, 0)
			ressourceBar0.bg:SetVertexColor(0, 0.65, 0)
		elseif percentage <= 60 then
			ressourceBar0.value:SetTextColor(1, 1, 0)
			ressourceBar0:SetStatusBarColor(1, 1, 0)
			ressourceBar0.bg:SetVertexColor(0.65, 0.65, 0)
		elseif percentage > 60 then
			ressourceBar1.value:SetTextColor(1, 0, 0)
			ressourceBar1:SetStatusBarColor(1, 0, 0)
			ressourceBar1.bg:SetVertexColor(0.65, 0, 0)
		end
	end
	if name == "Health" then
		if percentage >= 75 then
			ressourceBar0.value:SetTextColor(0, 1, 0)
			ressourceBar0:SetStatusBarColor(0, 1, 0)
			ressourceBar0.bg:SetVertexColor(0, 0.65, 0)
		elseif percentage >=50 then
			ressourceBar0.value:SetTextColor(1, 1, 0)
			ressourceBar0:SetStatusBarColor(1, 1, 0)
			ressourceBar0.bg:SetVertexColor(0.65, 0.65, 0)
		elseif percentage < 50 then
			ressourceBar0.value:SetTextColor(1, 0, 0)
			ressourceBar0:SetStatusBarColor(1, 0, 0)
			ressourceBar0.bg:SetVertexColor(0.65, 0, 0)
		end
	end
	ressourceBar0.value:SetText(percentage .. " % " .. name)
	ressourceBar0:SetValue(percentage)
end

function recalculateResolve()
	local _, _, _, _, _, _, _, _, _, _, _, _, _, _, perc, last = UnitBuff("player", resolveId)
	if last == nil
	then
		resolve_frame:Hide()
	else
		if last > 1000 then
			resolve_frame_perc.value:SetText(perc .. " % / " .. math.floor(last/10000) .. "k dtps")
		else
			resolve_frame_perc.value:SetText(perc .. " % / " .. math.floor(last/10) .. " dtps")
		end
		resolve_frame_perc:SetValue(perc)
		resolve_frame:Show()
	end
end

local function updateScreen(currentMana,maxMana,currentRage,maxRage,currentFocus,maxFocus,currentEnergy,maxEnergy,currentRunicPower,maxRunicPower,currentSoulShards,maxSoulShards,currentHolyPower,maxHolyPower,currentChi,maxChi,currentShadowOrbs,maxShadowOrbs,currentBurningEmbers,maxBurningEmbers,currentDemonicFury,maxDemonicFury,stagger,currentHealth,maxHealth)
	-- DEFAULT_CHAT_FRAME:AddMessage( currentMana .. " " ..maxMana .. " " ..currentRage .. " " ..maxRage .. " " ..currentFocus .. " " ..maxFocus .. " " ..currentEnergy .. " " ..maxEnergy .. " " ..currentRunicPower .. " " ..maxRunicPower .. " " ..currentSoulShards .. " " ..maxSoulShards .. " " ..currentHolyPower .. " " ..maxHolyPower .. " " ..currentChi .. " " ..maxChi .. " " ..currentShadowOrbs .. " " ..maxShadowOrbs .. " " ..currentBurningEmbers .. " " ..maxBurningEmbers .. " " ..currentDemonicFury .. " " ..maxDemonicFury .. " " ..stagger .. " " ..health .. " " ..maxHealth)
	if currentSelectedRessource0 == "---" then
		ressourceBar0:Hide()
	else
		ressourceBar0:Show()
	end
	if currentSelectedRessource0 == "Health" then
		updateRessourceBar0(currentHealth,maxHealth,"Health")
	elseif currentSelectedRessource0 == "Mana" then
		updateRessourceBar0(currentMana,maxMana,"Mana")
	elseif currentSelectedRessource0 == "Rage" then
		updateRessourceBar0(currentRage,maxRage,"Rage")
	elseif currentSelectedRessource0 == "Focus" then
		updateRessourceBar0(currentFocus,maxFocus,"Focus")
	elseif currentSelectedRessource0 == "Energy" then
		updateRessourceBar0(currentEnergy,maxEnergy,"Energy")
	elseif currentSelectedRessource0 == "Runic Power" then
		updateRessourceBar0(currentRunicPower,maxRunicPower,"Runic Power")
	elseif currentSelectedRessource0 == "Soul Shards" then
		updateRessourceBar0(currentSoulShards,maxSoulShards,"Soul Shards")
	elseif currentSelectedRessource0 == "Holy Power" then
		updateRessourceBar0(currentHolyPower,maxHolyPower,"Holy Power")
	elseif currentSelectedRessource0 == "Chi" then
		updateRessourceBar0(currentChi,maxChi,"Chi")
	elseif currentSelectedRessource0 == "Shadow Orbs" then
		updateRessourceBar0(currentShadowOrbs,maxShadowOrbs,"Shadow Orbs")
	elseif currentSelectedRessource0 == "Burning Embers" then
		updateRessourceBar0(currentBurningEmbers,maxBurningEmbers,"Burning Embers")
	elseif currentSelectedRessource0 == "Demonic Fury" then
		updateRessourceBar0(currentDemonicFury,maxDemonicFury,"Demonic Fury")
	elseif currentSelectedRessource0 == "Stagger" then
		updateRessourceBar0(stagger,maxHealth,"Stagger")
	end
	if currentSelectedRessource1 == "---" then
		ressourceBar1:Hide()
	else
		ressourceBar1:Show()
	end
	if currentSelectedRessource1 == "Health" then
		updateRessourceBar1(currentHealth,maxHealth,"Health")
	elseif currentSelectedRessource1 == "Mana" then
		updateRessourceBar1(currentMana,maxMana,"Mana")
	elseif currentSelectedRessource1 == "Rage" then
		updateRessourceBar1(currentRage,maxRage,"Rage")
	elseif currentSelectedRessource1 == "Focus" then
		updateRessourceBar1(currentFocus,maxFocus,"Focus")
	elseif currentSelectedRessource1 == "Energy" then
		updateRessourceBar1(currentEnergy,maxEnergy,"Energy")
	elseif currentSelectedRessource1 == "Runic Power" then
		updateRessourceBar1(currentRunicPower,maxRunicPower,"Runic Power")
	elseif currentSelectedRessource1 == "Soul Shards" then
		updateRessourceBar1(currentSoulShards,maxSoulShards,"Soul Shards")
	elseif currentSelectedRessource1 == "Holy Power" then
		updateRessourceBar1(currentHolyPower,maxHolyPower,"Holy Power")
	elseif currentSelectedRessource1 == "Chi" then
		updateRessourceBar1(currentChi,maxChi,"Chi")
	elseif currentSelectedRessource1 == "Shadow Orbs" then
		updateRessourceBar1(currentShadowOrbs,maxShadowOrbs,"Shadow Orbs")
	elseif currentSelectedRessource1 == "Burning Embers" then
		updateRessourceBar1(currentBurningEmbers,maxBurningEmbers,"Burning Embers")
	elseif currentSelectedRessource1 == "Demonic Fury" then
		updateRessourceBar1(currentDemonicFury,maxDemonicFury,"Demonic Fury")
	elseif currentSelectedRessource1 == "Stagger" then
		updateRessourceBar1(stagger,maxHealth,"Stagger")
	end
	if currentSelectedRessource2 == "---" then
		ressourceBar2:Hide()
	else
		ressourceBar2:Show()
	end
	if currentSelectedRessource2 == "Health" then
		updateRessourceBar2(currentHealth,maxHealth,"Health")
	elseif currentSelectedRessource2 == "Mana" then
		updateRessourceBar2(currentMana,maxMana,"Mana")
	elseif currentSelectedRessource2 == "Rage" then
		updateRessourceBar2(currentRage,maxRage,"Rage")
	elseif currentSelectedRessource2 == "Focus" then
		updateRessourceBar2(currentFocus,maxFocus,"Focus")
	elseif currentSelectedRessource2 == "Energy" then
		updateRessourceBar2(currentEnergy,maxEnergy,"Energy")
	elseif currentSelectedRessource2 == "Runic Power" then
		updateRessourceBar2(currentRunicPower,maxRunicPower,"Runic Power")
	elseif currentSelectedRessource2 == "Soul Shards" then
		updateRessourceBar2(currentSoulShards,maxSoulShards,"Soul Shards")
	elseif currentSelectedRessource2 == "Holy Power" then
		updateRessourceBar2(currentHolyPower,maxHolyPower,"Holy Power")
	elseif currentSelectedRessource2 == "Chi" then
		updateRessourceBar2(currentChi,maxChi,"Chi")
	elseif currentSelectedRessource2 == "Shadow Orbs" then
		updateRessourceBar2(currentShadowOrbs,maxShadowOrbs,"Shadow Orbs")
	elseif currentSelectedRessource2 == "Burning Embers" then
		updateRessourceBar2(currentBurningEmbers,maxBurningEmbers,"Burning Embers")
	elseif currentSelectedRessource2 == "Demonic Fury" then
		updateRessourceBar2(currentDemonicFury,maxDemonicFury,"Demonic Fury")
	elseif currentSelectedRessource2 == "Stagger" then
		updateRessourceBar2(stagger,maxHealth,"Stagger")
	end
	recalculateResolve()
end


local function updateBar()

-- POWER_INDEX_VARIABLE  POWER_INDEX   Type
-- =================================================================================================
-- SPELL_POWER_MANA            0             Mana
-- SPELL_POWER_RAGE            1             Rage
-- SPELL_POWER_FOCUS           2             Focus
-- SPELL_POWER_ENERGY          3             Energy
-- SPELL_POWER_HAPPINESS       4             Pet Happiness
-- SPELL_POWER_RUNES           5             Deathknight Runes
-- SPELL_POWER_RUNIC_POWER     6             Deathknight Runic Power
-- SPELL_POWER_SOUL_SHARDS     7             Warlock Affliction Soul Shards
-- SPELL_POWER_ECLIPSE         8             Druid Balance Eclipse
-- SPELL_POWER_HOLY_POWER      9             Paladin Holy Power
-- SPELL_POWER_ALTERNATE_POWER 10            Alternate Power used in certain boss encounters or in mini-games
-- SPELL_POWER_DARK_FORCE      11            --
-- SPELL_POWER_CHI             12            Monk Chi
-- SPELL_POWER_SHADOW_ORBS     13            Priest Shadow Orbs
-- SPELL_POWER_BURNING_EMBERS  14            Warlock Destruction Burning Embers
-- SPELL_POWER_DEMONIC_FURY    15            Warlock Demonology Demonic Fury
	local currentMana = UnitPower("player", 0)
	local maxMana = UnitPowerMax("player", 0)
	local currentRage = UnitPower("player", 1)
	local maxRage = UnitPowerMax("player", 1)
	local currentFocus = UnitPower("player", 2)
	local maxFocus = UnitPowerMax("player", 2)
	local currentEnergy = UnitPower("player", 3)
	local maxEnergy = UnitPowerMax("player", 3)
	local currentRunicPower = UnitPower("player", 6)
	local maxRunicPower = UnitPowerMax("player", 6)
	local currentSoulShards = UnitPower("player", 7)
	local maxSoulShards = UnitPowerMax("player", 7)
	local currentHolyPower = UnitPower("player", 9)
	local maxHolyPower = UnitPowerMax("player", 9)
	local currentChi = UnitPower("player", 12)
	local maxChi = UnitPowerMax("player", 12)
	local currentShadowOrbs = UnitPower("player", 13)
	local maxShadowOrbs = UnitPowerMax("player", 13)
	local currentBurningEmbers = UnitPower("player", 14)
	local maxBurningEmbers = UnitPowerMax("player", 14)
	local currentDemonicFury = UnitPower("player", 15)
	local maxDemonicFury = UnitPowerMax("player", 15)
	local stagger = UnitStagger("player")
	local health = UnitHealth("player");
	local maxHealth = UnitHealthMax("player");
	updateScreen(currentMana,maxMana,currentRage,maxRage,currentFocus,maxFocus,currentEnergy,maxEnergy,currentRunicPower,maxRunicPower,currentSoulShards,maxSoulShards,currentHolyPower,maxHolyPower,currentChi,maxChi,currentShadowOrbs,maxShadowOrbs,currentBurningEmbers,maxBurningEmbers,currentDemonicFury,maxDemonicFury,stagger,health,maxHealth)
end

function onDynamicUpdateTimers()
	if showBuffs:GetChecked() then
		for i=1,40 do 
			local n,_,icon,_,_,_,_,_,isStealable,_,spellid=UnitAura("player",i);
			if spellid == nil then
			else
				DEFAULT_CHAT_FRAME:AddMessage( "Buff: " .. n .. " id " .. spellid );
			end
		end
	end
	if showDebuffs:GetChecked() then
		for i=1,40 do 
			local n,_,icon,_,_,_,_,_,isStealable,_,spellid=UnitDebuff("player",i);
			if spellid == nil then
			else
				DEFAULT_CHAT_FRAME:AddMessage( "Debuff: " .. n  .. " id " .. spellid );
			end
		end
	end

	-- BUFFS
	if buff1:GetNumber() == 0 then
		if buff1:GetText() == "" then
			resetIcon(buff1Icon)
		else
			refreshBuffByName(buff1:GetText(),buff1Icon)
		end
	else
		refreshBuff(buff1:GetNumber(),buff1Icon)
	end
	if buff2:GetNumber() == 0 then
		if buff2:GetText() == "" then
			resetIcon(buff2Icon)
		else
			refreshBuffByName(buff2:GetText(),buff2Icon)
		end
	else
		refreshBuff(buff2:GetNumber(),buff2Icon)
	end
	if buff3:GetNumber() == 0 then
		if buff3:GetText() == "" then
			resetIcon(buff3Icon)
		else
			refreshBuffByName(buff3:GetText(),buff3Icon)
		end
	else
		refreshBuff(buff3:GetNumber(),buff3Icon)
	end
	if buff4:GetNumber() == 0 then
		if buff4:GetText() == "" then
			resetIcon(buff4Icon)
		else
			refreshBuffByName(buff4:GetText(),buff4Icon)
		end
	else
		refreshBuff(buff4:GetNumber(),buff4Icon)
	end
	if buff5:GetNumber() == 0 then
		if buff5:GetText() == "" then
			resetIcon(buff5Icon)
		else
			refreshBuffByName(buff5:GetText(),buff5Icon)
		end
	else
		refreshBuff(buff5:GetNumber(),buff5Icon)
	end
	if buff6:GetNumber() == 0 then
		if buff6:GetText() == "" then
			resetIcon(buff6Icon)
		else
			refreshBuffByName(buff6:GetText(),buff6Icon)
		end
	else
		refreshBuff(buff6:GetNumber(),buff6Icon)
	end

	-- DEBUFFS
	if automaticDebuffCheckFrame:GetChecked() == true then
		refreshAllDebuff()
	else
	if debuff1:GetNumber() == 0 then
		if debuff1:GetText() == "" then
			resetIcon(debuff1Icon)
		else
			refreshDebuffByName(debuff1:GetText(),debuff1Icon)
		end
	else
		refreshDebuff(debuff1:GetNumber(),debuff1Icon)
	end
	if debuff2:GetNumber() == 0 then
		if debuff2:GetText() == "" then
			resetIcon(debuff2Icon)
		else
			refreshDebuffByName(debuff2:GetText(),debuff2Icon)
		end
	else
		refreshDebuff(debuff2:GetNumber(),debuff2Icon)
	end
	if debuff3:GetNumber() == 0 then
		if debuff3:GetText() == "" then
			resetIcon(debuff3Icon)
		else
			refreshDebuffByName(debuff3:GetText(),debuff3Icon)
		end
	else
		refreshDebuff(debuff3:GetNumber(),debuff3Icon)
	end
	if debuff4:GetNumber() == 0 then
		if debuff4:GetText() == "" then
			resetIcon(debuff4Icon)
		else
			refreshDebuffByName(debuff4:GetText(),debuff4Icon)
		end
	else
		refreshDebuff(debuff4:GetNumber(),debuff4Icon)
	end
	if debuff5:GetNumber() == 0 then
		if debuff5:GetText() == "" then
			resetIcon(debuff5Icon)
		else
			refreshDebuffByName(debuff5:GetText(),debuff5Icon)
		end
	else
		refreshDebuff(debuff5:GetNumber(),debuff5Icon)
	end
	if debuff6:GetNumber() == 0 then
		if debuff6:GetText() == "" then
			resetIcon(debuff6Icon)
		else
			refreshDebuffByName(debuff6:GetText(),debuff6Icon)
		end
	else
		refreshDebuff(debuff6:GetNumber(),debuff6Icon)
	end
	end
end

function resetIcon(bufficon)
	-- DEFAULT_CHAT_FRAME:AddMessage( "Reset of icon " );
	bufficon.text:SetText( "" )
	bufficon:Hide()
end

function refreshBuff(buffspellid,bufficon)
	-- DEFAULT_CHAT_FRAME:AddMessage( "Searching for buff Debuff: " .. buffspellid );
	local buffFound = false
	for i=1,40 do
		local name,rank,icon,count,dispellType,duration,expires,caster,isStealable,shouldConsolidate,spellId=UnitAura("player",i)
		if spellId == buffspellid then
			bufficon.texture:SetTexture(icon)
			if count == 0 then
				if expires == 0 then
				else
					bufficon.text:SetText( math.floor(expires-GetTime()) )
				end
			else
				bufficon.text:SetText(count)
			end
			bufficon:Show()
			buffFound = true
		end
	end
	if buffFound == false then
		bufficon:Hide()
	end
end

function refreshBuffByName(buffspellname,bufficon)
	-- DEFAULT_CHAT_FRAME:AddMessage( "Searching for buff Debuff: " .. buffspellname );
	local buffFound = false
	for i=1,40 do
		local name,rank,icon,count,dispellType,duration,expires,caster,isStealable,shouldConsolidate,spellId=UnitAura("player",i)
		if name == buffspellname then
			bufficon.texture:SetTexture(icon)
			if count == 0 then
				if expires == 0 then
				else
					bufficon.text:SetText( math.floor(expires-GetTime()) )
				end
			else
				bufficon.text:SetText(count)
			end
			bufficon:Show()
			buffFound = true
		end
	end
	if buffFound == false then
		bufficon:Hide()
	end
end

function refreshDebuff(debuffspellid,bufficon)
	-- DEFAULT_CHAT_FRAME:AddMessage( "Searching for debuff Debuff: " .. debuffspellid );
	local buffFound = false
	for i=1,40 do
		local name,rank,icon,count,dispellType,duration,expires,caster,isStealable,shouldConsolidate,spellId,canApplyAura,isBossDebuff,value1,value2=UnitDebuff("player",i)
		if spellId == debuffspellid then
			-- DEFAULT_CHAT_FRAME:AddMessage( "Debuff: " .. name  .. " spellId " .. spellId );
			bufficon.texture:SetTexture(icon)
			if count == 0 then
				if expires == 0 then
				else
					bufficon.text:SetText( math.floor(expires-GetTime()))
				end
			else
				bufficon.text:SetText(count)
			end
			bufficon:Show()
			buffFound = true
		end
	end
	if buffFound == false then
		bufficon:Hide()
	end
end

function refreshDebuffByName(debuffspellname,bufficon)
	-- DEFAULT_CHAT_FRAME:AddMessage( "Searching for debuff Debuff: " .. debuffspellname );
	local buffFound = false
	for i=1,40 do
		local name,rank,icon,count,dispellType,duration,expires,caster,isStealable,shouldConsolidate,spellId,canApplyAura,isBossDebuff,value1,value2=UnitDebuff("player",i)
		if name == debuffspellname then
			-- DEFAULT_CHAT_FRAME:AddMessage( "Debuff: " .. name  .. " spellId " .. spellId );
			bufficon.texture:SetTexture(icon)
			if count == 0 then
				if expires == 0 then
				else
					bufficon.text:SetText( math.floor(expires-GetTime()))
				end
			else
				bufficon.text:SetText(count)
			end
			bufficon:Show()
			buffFound = true
		end
	end
	if buffFound == false then
		bufficon:Hide()
	end
end

function refreshAllDebuff()
	-- DEFAULT_CHAT_FRAME:AddMessage( "Searching for all debuff" );
	local buffFound = false
	for i=1,6 do
		local name,rank,icon,count,dispellType,duration,expires,caster,isStealable,shouldConsolidate,spellId,canApplyAura,isBossDebuff,value1,value2=UnitDebuff("player",i)
		--if spellId ~= nil then
		--	DEFAULT_CHAT_FRAME:AddMessage( "Debuff: " .. name  .. " spellId " .. spellId );
		--end
		if i == 1 then
			if spellId ~= nil then
				refreshDebuff(spellId,debuff1Icon)
			else
				debuff1Icon:Hide()
			end
		end
		if i == 2 then
			if spellId ~= nil then
				refreshDebuff(spellId,debuff2Icon)
			else
				debuff2Icon:Hide()
			end
		end
		if i == 3 then
			if spellId ~= nil then
				refreshDebuff(spellId,debuff3Icon)
			else
				debuff3Icon:Hide()
			end
		end
		if i == 4 then
			if spellId ~= nil then
				refreshDebuff(spellId,debuff4Icon)
			else
				debuff4Icon:Hide()
			end
		end
		if i == 5 then
			if spellId ~= nil then
				refreshDebuff(spellId,debuff5Icon)
			else
				debuff5Icon:Hide()
			end
		end
		if i == 6 then
			if spellId ~= nil then
				refreshDebuff(spellId,debuff6Icon)
			else
				debuff6Icon:Hide()
			end
		end
	end
end

local elapsedDynamicTime = 0;

function onDynamicBuffFrameUpdate(self,elapsed)
	elapsedDynamicTime = elapsedDynamicTime + elapsed
	local pingReady = 0
	if elapsedDynamicTime >= 1 then
		pingReady  = 1
        	elapsedDynamicTime = 0
	end
	if pingReady == 1 then
		updateBar()
		onDynamicUpdateTimers()
	end
end

local function spellCast(unit,spell)
	if unit == "target" then
		-- DEFAULT_CHAT_FRAME:AddMessage( "StopSpell " .. unit .. " " .. spell );
		if lookAndFeelHideCastWarning:GetChecked() then
			return
		end
		castbar1:SetValue(100)
		castbar1.value:SetText(spell)
		if lookAndFeelBorderFrame:GetChecked() then
			castbarFrame:Show()
		end
	end
end

local function stopSpellCast(unit,spell)
	if unit == "target" then
		-- DEFAULT_CHAT_FRAME:AddMessage( "Spell " .. unit .. " " .. spell );
		if lookAndFeelHideCastWarning:GetChecked() then
			return
		end
		castbar1:SetValue(0)
		castbar1.value:SetText("")
		if lookAndFeelBorderFrame:GetChecked() then
			castbarFrame:Hide()
		end
	end
end

local function targetChange(unit)
	if unit == "player" then
		-- DEFAULT_CHAT_FRAME:AddMessage( "targetChange " .. unit );
		if lookAndFeelHideCastWarning:GetChecked() then
			return
		end
		name, subText, text, texture, startTime, endTime, isTradeSkill, castID, notInterruptible = UnitCastingInfo("target")
		if name == nil then
			castbar1:SetValue(0)
			castbar1.value:SetText("")
			if lookAndFeelBorderFrame:GetChecked() then
				castbarFrame:Hide()
			end
		else
			castbar1:SetValue(100)
			castbar1.value:SetText(name)
			if lookAndFeelBorderFrame:GetChecked() then
				castbarFrame:Show()
			end
		end
	end
end

local function recalculateXp()
	local currXP = UnitXP("player");
	local needXP = UnitXPMax("player");

	experienceBar1:SetMinMaxValues(0, needXP);
	experienceBar1:SetValue(currXP);
	experienceBar1.value:SetText( currXP .. "/" .. needXP .. " xp" )

end

local function recalculateFaction()
	local name, standingID, barMin, barMax, barValue = GetWatchedFactionInfo()
	if name ~= nil then
		factionBar1:SetMinMaxValues(0, barMax);
		factionBar1:SetValue(barValue);
		factionBar1.value:SetText( barValue .. "/" .. barMax .. " " .. name )
	else
		factionBar1:SetMinMaxValues(0, 0);
		factionBar1:SetValue(0);
		factionBar1.value:SetText( "0/0 ---" )
	end
end


function OnDynamicBuffFrameEvent(self, event, arg1, arg2, ...)
	if event == "UNIT_MAXPOWER" then
		updateBar()
	elseif event == "UNIT_POWER" then
		updateBar()
	elseif event == "UNIT_HEALTH" then
		updateBar()
	elseif event == "UNIT_DISPLAYPOWER" then
		updateBar()
	elseif event == "PLAYER_LOGOUT" then
		saveAddon()
	elseif event == "ADDON_LOADED" then
		loadAddon()
		recalculateXp()
		recalculateFaction()
	elseif event == "UNIT_SPELLCAST_START" then
		spellCast(arg1,arg2)
	elseif event == "UNIT_SPELLCAST_CHANNEL_START" then
		spellCast(arg1,arg2)
	elseif event == "UNIT_SPELLCAST_STOP" then
		stopSpellCast(arg1,arg2)
	elseif event == "UNIT_SPELLCAST_CHANNEL_STOP" then
		stopSpellCast(arg1,arg2)
	elseif event == "UNIT_TARGET" then
		targetChange(arg1)
	elseif event == "UPDATE_FACTION" then
		recalculateFaction()
	elseif event == "PLAYER_XP_UPDATE" then
		recalculateXp()
	elseif event == "PLAYER_LEVEL_UP" then
		recalculateXp()
	end
end

-------------------------------------------------------

dynamicBuffFrame:RegisterEvent("ADDON_LOADED")
dynamicBuffFrame:RegisterEvent("UNIT_MAXPOWER")
dynamicBuffFrame:RegisterEvent("UNIT_POWER")
dynamicBuffFrame:RegisterEvent("UNIT_HEALTH")
dynamicBuffFrame:RegisterEvent("UNIT_AURA")
dynamicBuffFrame:RegisterEvent("UNIT_DISPLAYPOWER")
dynamicBuffFrame:RegisterEvent("PLAYER_LOGOUT")
dynamicBuffFrame:RegisterEvent("UNIT_SPELLCAST_START")
dynamicBuffFrame:RegisterEvent("UNIT_SPELLCAST_STOP")
dynamicBuffFrame:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START")
dynamicBuffFrame:RegisterEvent("UNIT_SPELLCAST_CHANNEL_STOP")
dynamicBuffFrame:RegisterEvent("UNIT_TARGET")
dynamicBuffFrame:RegisterEvent("PLAYER_XP_UPDATE");
dynamicBuffFrame:RegisterEvent("PLAYER_LEVEL_UP");
dynamicBuffFrame:RegisterEvent("UPDATE_FACTION");
dynamicBuffFrame:SetScript("OnEvent",OnDynamicBuffFrameEvent)
dynamicBuffFrame:SetScript("OnUpdate",onDynamicBuffFrameUpdate)

--------------------------- ACTIONBARS
-- HIDE
local function hideBlizzFrame()
	local pastebin = CreateFrame("Frame")
	pastebin:Hide()

	MainMenuBar:SetParent(pastebin)
	MainMenuBarPageNumber:SetParent(pastebin)
	ActionBarDownButton:SetParent(pastebin)
	ActionBarUpButton:SetParent(pastebin)
  
	OverrideActionBarExpBar:SetParent(pastebin)
	OverrideActionBarHealthBar:SetParent(pastebin)
	OverrideActionBarPowerBar:SetParent(pastebin)
	OverrideActionBarPitchFrame:SetParent(pastebin)
	StanceBarLeft:SetTexture(nil)
	StanceBarMiddle:SetTexture(nil)
	StanceBarRight:SetTexture(nil)
	SlidingActionBarTexture0:SetTexture(nil)
	SlidingActionBarTexture1:SetTexture(nil)
	PossessBackground1:SetTexture(nil)
	PossessBackground2:SetTexture(nil)
	MainMenuBarTexture0:SetTexture(nil)
	MainMenuBarTexture1:SetTexture(nil)
	MainMenuBarTexture2:SetTexture(nil)
	MainMenuBarTexture3:SetTexture(nil)
	MainMenuBarLeftEndCap:SetTexture(nil)
	MainMenuBarRightEndCap:SetTexture(nil)
	OverrideActionBar["_BG"]:SetAlpha(0)
	OverrideActionBar["EndCapL"]:SetAlpha(0)
	OverrideActionBar["EndCapR"]:SetAlpha(0)
	OverrideActionBar["_Border"]:SetAlpha(0)
	OverrideActionBar["Divider1"]:SetAlpha(0)
	OverrideActionBar["Divider2"]:SetAlpha(0)
	OverrideActionBar["Divider3"]:SetAlpha(0)
	OverrideActionBar["ExitBG"]:SetAlpha(0)
	OverrideActionBar["MicroBGL"]:SetAlpha(0)
	OverrideActionBar["MicroBGR"]:SetAlpha(0)
	OverrideActionBar["_MicroBGMid"]:SetAlpha(0)
	OverrideActionBar["ButtonBGL"]:SetAlpha(0)
	OverrideActionBar["ButtonBGR"]:SetAlpha(0)
	OverrideActionBar["_ButtonBGMid"]:SetAlpha(0)
end
------ Special Bar
local function createOverwriteBar()
	local buttonSize = 30
	local num = 6
  	local frame = CreateFrame("Frame", "rABS_OverrideBar", UIParent, "SecureHandlerStateTemplate")
	frame:SetWidth((num*buttonSize + (num-1)*5 + 2*5)+10)
	frame:SetHeight((buttonSize + 2*5)+15)
	frame:SetPoint("BOTTOM","UIParent","BOTTOM",-10,5)
	frame:SetScale(1)
	frame:SetBackdrop({
		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
		tile=1, tileSize=32, edgeSize=15, 
		insets={left=0, right=0, top=0, bottom=0}
	})
	--frame:EnableMouse(true)
	--frame:SetMovable(true)
	--frame:RegisterForDrag("LeftButton")
	--frame:SetScript("OnDragStart", function(self) self:StartMoving() end)
	--frame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
	--frame:SetFrameStrata("FULLSCREEN_DIALOG")

	OverrideActionBar:SetParent(frame)
	OverrideActionBar:EnableMouse(false)
	OverrideActionBar:SetScript("OnShow", nil) --remove the onshow script

	OverrideActionBar.LeaveButton:Hide()

	for i=1, num do
		local button =  _G["OverrideActionBarButton"..i]
		if not button then
			break
		end
		button:SetSize(buttonSize, buttonSize)
		button:ClearAllPoints()
		if i == 1 then
			button:SetPoint("LEFT", frame, 10, -5)
		else
			local previous = _G["OverrideActionBarButton"..i-1]
			button:SetPoint("LEFT", previous, "RIGHT", 5, 0)
		end
	end
	
	RegisterStateDriver(frame, "visibility", "[petbattle] hide; [overridebar][vehicleui][possessbar,@vehicle,exists] show; hide")
	RegisterStateDriver(OverrideActionBar, "visibility", "[overridebar][vehicleui][possessbar,@vehicle,exists] show; hide")
end
------ VEHICLEBUTTON
local function createVehicleBar(num,buttonSize,marginSize,paddingSize,frameName)
	local mainButtonFrame = CreateFrame("Frame", frameName, UIParent, "SecureHandlerStateTemplate")
	mainButtonFrame:SetWidth((num*buttonSize + (num-1)*marginSize + 2*paddingSize)+10)
	mainButtonFrame:SetHeight((buttonSize + 2*paddingSize)+10)
	mainButtonFrame:SetPoint("BOTTOM","UIParent","BOTTOM",300,0)
	mainButtonFrame:SetScale(1)
	mainButtonFrame:SetBackdrop({
		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
		tile=1, tileSize=32, edgeSize=15, 
		insets={left=0, right=0, top=0, bottom=0}
	})
	mainButtonFrame:EnableMouse(true)
	mainButtonFrame:SetMovable(true)
	mainButtonFrame:RegisterForDrag("LeftButton")
	mainButtonFrame:SetScript("OnDragStart", function(self) self:StartMoving() end)
	mainButtonFrame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
	mainButtonFrame:SetFrameStrata("FULLSCREEN_DIALOG")

	local frame = CreateFrame("Frame", "bar"..frameName, mainButtonFrame, "SecureHandlerStateTemplate")
	frame:SetWidth(num*buttonSize + (num-1)*marginSize + 2*paddingSize)
	frame:SetHeight(buttonSize + 2*paddingSize)
	frame:SetPoint("CENTER", mainButtonFrame ,"CENTER",0,0)
	frame:SetScale(1)

	local button = CreateFrame("BUTTON", "vehicleButton", frame, "SecureHandlerClickTemplate, SecureHandlerStateTemplate")
	button:SetSize(buttonSize, buttonSize)
	button:SetPoint("BOTTOMLEFT", frame, paddingSize, paddingSize)
	button:RegisterForClicks("AnyUp")
	button:SetScript("OnClick", VehicleExit)

	button:SetNormalTexture("INTERFACE\\PLAYERACTIONBARALT\\NATURAL")
	button:SetPushedTexture("INTERFACE\\PLAYERACTIONBARALT\\NATURAL")
	button:SetHighlightTexture("INTERFACE\\PLAYERACTIONBARALT\\NATURAL")

	local nt = button:GetNormalTexture()
	local pu = button:GetPushedTexture()
	local hi = button:GetHighlightTexture()
	nt:SetTexCoord(0.0859375,0.1679688,0.359375,0.4414063)
	pu:SetTexCoord(0.001953125,0.08398438,0.359375,0.4414063)
	hi:SetTexCoord(0.6152344,0.6972656,0.359375,0.4414063)
	hi:SetBlendMode("ADD")
end
------ ACTIONBARS
local function createActionBar2(num,buttonSize,marginSize,paddingSize,frameName,mainframe,buttonTemplate,sitea,siteb,x,y,mainButtonFrame)
	mainButtonFrame:SetWidth((num*buttonSize + (num-1)*marginSize + 2*paddingSize)+10)
	mainButtonFrame:SetHeight((buttonSize + 2*paddingSize)+10)
	mainButtonFrame:SetPoint(sitea,"UIParent",siteb,x,y)
	mainButtonFrame:SetScale(1)
	mainButtonFrame:SetBackdrop({
		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
		tile=1, tileSize=32, edgeSize=15, 
		insets={left=0, right=0, top=0, bottom=0}
	})
	mainButtonFrame:EnableMouse(true)
	mainButtonFrame:SetMovable(true)
	mainButtonFrame:RegisterForDrag("LeftButton")
	mainButtonFrame:SetScript("OnDragStart", function(self) self:StartMoving() end)
	mainButtonFrame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
	mainButtonFrame:SetFrameStrata("FULLSCREEN_DIALOG")

	local frame = CreateFrame("Frame", "bar"..frameName, mainButtonFrame, "SecureHandlerStateTemplate")
	frame:SetWidth(num*buttonSize + (num-1)*marginSize + 2*paddingSize)
	frame:SetHeight(buttonSize + 2*paddingSize)
	frame:SetPoint("CENTER", mainButtonFrame ,"CENTER",0,0)
	frame:SetScale(1)

	mainframe:SetParent(frame)
	mainframe:SetScript("OnShow", nil) --remove the onshow script
	for i=1, num do
		local button = _G[buttonTemplate..i]
		if button ~= nil then
			button:SetSize(buttonSize, buttonSize)
			button:ClearAllPoints()    
			if i == 1 then
				button:SetPoint("BOTTOMLEFT", frame, paddingSize, paddingSize)
			else
				local previous = _G[buttonTemplate..i-1]
				button:SetPoint("LEFT", previous, "RIGHT", marginSize, 0)
			end
		end
	end
	RegisterStateDriver(mainButtonFrame, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")
end
------ ACTIONBARS
local function createActionBar(num,buttonSize,marginSize,paddingSize,frameName,mainframe,buttonTemplate,sitea,siteb,x,y)
	local mainButtonFrame = CreateFrame("Frame", frameName, UIParent, "SecureHandlerStateTemplate")
	mainButtonFrame:SetWidth((num*buttonSize + (num-1)*marginSize + 2*paddingSize)+10)
	mainButtonFrame:SetHeight((buttonSize + 2*paddingSize)+10)
	mainButtonFrame:SetPoint(sitea,"UIParent",siteb,x,y)
	mainButtonFrame:SetScale(1)
	mainButtonFrame:SetBackdrop({
		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
		tile=1, tileSize=32, edgeSize=15, 
		insets={left=0, right=0, top=0, bottom=0}
	})
	mainButtonFrame:EnableMouse(true)
	mainButtonFrame:SetMovable(true)
	mainButtonFrame:RegisterForDrag("LeftButton")
	mainButtonFrame:SetScript("OnDragStart", function(self) self:StartMoving() end)
	mainButtonFrame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
	mainButtonFrame:SetFrameStrata("FULLSCREEN_DIALOG")

	local frame = CreateFrame("Frame", "bar"..frameName, mainButtonFrame, "SecureHandlerStateTemplate")
	frame:SetWidth(num*buttonSize + (num-1)*marginSize + 2*paddingSize)
	frame:SetHeight(buttonSize + 2*paddingSize)
	frame:SetPoint("CENTER", mainButtonFrame ,"CENTER",0,0)
	frame:SetScale(1)

	mainframe:SetParent(frame)
	mainframe:SetScript("OnShow", nil) --remove the onshow script
	for i=1, num do
		local button = _G[buttonTemplate..i]
		if button ~= nil then
			button:SetSize(buttonSize, buttonSize)
			button:ClearAllPoints()    
			if i == 1 then
				button:SetPoint("BOTTOMLEFT", frame, paddingSize, paddingSize)
			else
				local previous = _G[buttonTemplate..i-1]
				button:SetPoint("LEFT", previous, "RIGHT", marginSize, 0)
			end
		end
	end
	RegisterStateDriver(mainButtonFrame, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists] hide; show")
end

local function createPetActionBar(num,buttonSize,marginSize,paddingSize,frameName,mainframe,buttonTemplate,sitea,siteb,x,y)
	local mainButtonFrame = CreateFrame("Frame", frameName, UIParent, "SecureHandlerStateTemplate")
	mainButtonFrame:SetWidth((num*buttonSize + (num-1)*marginSize + 2*paddingSize)+10)
	mainButtonFrame:SetHeight((buttonSize + 2*paddingSize)+10)
	mainButtonFrame:SetPoint(sitea,"UIParent",siteb,x,y)
	mainButtonFrame:SetScale(1)
	mainButtonFrame:SetBackdrop({
		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
		tile=1, tileSize=32, edgeSize=15, 
		insets={left=0, right=0, top=0, bottom=0}
	})
	mainButtonFrame:EnableMouse(true)
	mainButtonFrame:SetMovable(true)
	mainButtonFrame:RegisterForDrag("LeftButton")
	mainButtonFrame:SetScript("OnDragStart", function(self) self:StartMoving() end)
	mainButtonFrame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
	mainButtonFrame:SetFrameStrata("FULLSCREEN_DIALOG")

	local frame = CreateFrame("Frame", "bar"..frameName, mainButtonFrame, "SecureHandlerStateTemplate")
	frame:SetWidth(num*buttonSize + (num-1)*marginSize + 2*paddingSize)
	frame:SetHeight(buttonSize + 2*paddingSize)
	frame:SetPoint("CENTER", mainButtonFrame ,"CENTER",0,0)
	frame:SetScale(1)

	mainframe:SetParent(frame)
	mainframe:SetScript("OnShow", nil) --remove the onshow script
	for i=1, num do
		local button = _G[buttonTemplate..i]
		if button ~= nil then
			button:SetSize(buttonSize, buttonSize)
			button:ClearAllPoints()    
			if i == 1 then
				button:SetPoint("BOTTOMLEFT", frame, paddingSize, paddingSize)
			else
				local previous = _G[buttonTemplate..i-1]
				button:SetPoint("LEFT", previous, "RIGHT", marginSize, 0)
			end
		end
	end
	RegisterStateDriver(mainButtonFrame, "visibility", "[petbattle][overridebar][vehicleui][possessbar,@vehicle,exists][@pet,noexists] hide; show")
end

local function createBrewmasterLookAndFeel()
	local buttonSize = 30
	local marginSize = 5
	local paddingSize = 5
	createPetActionBar(NUM_ACTIONBAR_BUTTONS,buttonSize,marginSize,paddingSize,"PetBarFrame",PetActionBarFrame,"PetActionButton","BOTTOM","BOTTOM",0,0)
	createActionBar(NUM_ACTIONBAR_BUTTONS,buttonSize,marginSize,paddingSize,"ActionButtonFrame",MainMenuBarArtFrame,"ActionButton","BOTTOM","BOTTOM",0,40)
	createActionBar(NUM_ACTIONBAR_BUTTONS,buttonSize,marginSize,paddingSize,"MultiBarBottomLeftFrame",MultiBarBottomLeft,"MultiBarBottomLeftButton","BOTTOM","BOTTOM",0,80)
	createActionBar(NUM_ACTIONBAR_BUTTONS,buttonSize,marginSize,paddingSize,"MultiBarRightFrame",MultiBarRight,"MultiBarRightButton","BOTTOMLEFT","BOTTOMLEFT",0,0)
	createActionBar(NUM_ACTIONBAR_BUTTONS,buttonSize,marginSize,paddingSize,"MultiBarLeftFrame",MultiBarLeft,"MultiBarLeftButton","BOTTOMLEFT","BOTTOMLEFT",0,40)
	createActionBar(NUM_ACTIONBAR_BUTTONS,buttonSize,marginSize,paddingSize,"MultiBarBottomRightFrame",MultiBarBottomRight,"MultiBarBottomRightButton","BOTTOMLEFT","BOTTOMLEFT",0,80)
	createOverwriteBar()
	stanceFrame = CreateFrame("Frame", "StanceFrame", UIParent, "SecureHandlerStateTemplate")
	createActionBar2(6,buttonSize,marginSize,paddingSize,"StanceFrame",StanceBarFrame,"StanceButton","BOTTOM","BOTTOM",500,0,stanceFrame)
	createActionBar(1,60,marginSize,paddingSize,"ExtraActionFrame",ExtraActionBarFrame,"ExtraActionButton","BOTTOM","BOTTOM",-300,80)
	createVehicleBar(1,30,marginSize,paddingSize,"VehicleFrame")

	------ BAGS

	local bagButtonList = {
		MainMenuBarBackpackButton,
		CharacterBag0Slot,
		CharacterBag1Slot,
		CharacterBag2Slot,
		CharacterBag3Slot,
	}

	local NUM_BAG_BUTTONS = # bagButtonList
	local bagButtonWidth = MainMenuBarBackpackButton:GetWidth()
	local bagButtonHeight = MainMenuBarBackpackButton:GetHeight()

	bagFrame = CreateFrame("Frame", "bagFrame", UIParent, "SecureHandlerStateTemplate")
	bagFrame:SetWidth(NUM_BAG_BUTTONS*bagButtonWidth + (NUM_BAG_BUTTONS-1)*2 + 2*15)
	bagFrame:SetHeight(bagButtonHeight + 2*15)
	bagFrame:SetPoint("BOTTOMRIGHT","UIParent","BOTTOMRIGHT",0,0)
	bagFrame:SetScale(1)
	bagFrame:SetBackdrop({
		bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
		edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
		tile=1, tileSize=32, edgeSize=15, 
		insets={left=0, right=0, top=0, bottom=0}
	})

	for _, button in pairs(bagButtonList) do
		button:SetParent(bagFrame)
	end
	
	MainMenuBarBackpackButton:ClearAllPoints();
	MainMenuBarBackpackButton:SetPoint("RIGHT", -15, 0)

	--menu

	local MICRO_BUTTONS = MICRO_BUTTONS
	local menuButtonList = {}

	for _, buttonName in pairs(MICRO_BUTTONS) do
		local button = _G[buttonName]
		if button then
      			tinsert(menuButtonList, button)
	    	end
	end

	local NUM_MICROBUTTONS = # menuButtonList
	local menuBttonWidth = CharacterMicroButton:GetWidth()
	local menuButtonHeight = CharacterMicroButton:GetHeight()

	menuFrame = CreateFrame("Frame", ",menuFrame", UIParent, "SecureHandlerStateTemplate")
	menuFrame:SetWidth((NUM_MICROBUTTONS)*menuBttonWidth + (NUM_MICROBUTTONS-1)*-3 + 2*10)
	menuFrame:SetHeight(menuButtonHeight+2*10)
	menuFrame:SetPoint("TOP","UIParent","TOP",0,25)
	menuFrame:SetScale(1)

	menuFrame:EnableMouse(true)
	menuFrame:SetMovable(true)
	menuFrame:RegisterForDrag("LeftButton")
	menuFrame:SetScript("OnDragStart", function(self) self:StartMoving() end)
	menuFrame:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
	menuFrame:SetFrameStrata("FULLSCREEN_DIALOG")

	for _, button in pairs(menuButtonList) do
		button:SetParent(menuFrame)
	end
	CharacterMicroButton:ClearAllPoints();
	CharacterMicroButton:SetPoint("LEFT", 10, 0)
	PetBattleFrame.BottomFrame.MicroButtonFrame:SetScript("OnShow", nil)
	RegisterStateDriver(menuFrame, "visibility", "[petbattle] hide; show")
end
--------------------------- ACTIONBARS

local brewMasterInterfaceLoaded = false

local function checkForBrewmasterLookAndFeel()
	if useBrewmasterLookAndFeelConfig:GetChecked() then
		if brewMasterInterfaceLoaded == false then
			hideBlizzFrame()
			createBrewmasterLookAndFeel()
			brewMasterInterfaceLoaded = true
		end
	else
		experienceFrame:Hide()
		factionFrame:Hide()
	end
end

function loadAddon()
	-- DEFAULT_CHAT_FRAME:AddMessage( "loadAddon()");
	onLoadProcess = true
	if buffstring1 == nil then
	else
		buff1:SetText(buffstring1)
		buff1:SetCursorPosition(0)
	end
	if buffstring2 == nil then
	else
		buff2:SetText(buffstring2)
		buff2:SetCursorPosition(0)
	end
	if buffstring3 == nil then
	else
		buff3:SetText(buffstring3)
		buff3:SetCursorPosition(0)
	end
	if buffstring4 == nil then
	else
		buff4:SetText(buffstring4)
		buff4:SetCursorPosition(0)
	end
	if buffstring5 == nil then
	else
		buff5:SetText(buffstring5)
		buff5:SetCursorPosition(0)
	end
	if buffstring6 == nil then
	else
		buff6:SetText(buffstring6)
		buff6:SetCursorPosition(0)
	end
	if debuffstring1 == nil then
	else
		debuff1:SetText(debuffstring1)
		debuff1:SetCursorPosition(0)
	end
	if debuffstring2 == nil then
	else
		debuff2:SetText(debuffstring2)
		debuff2:SetCursorPosition(0)
	end
	if debuffstring3 == nil then
	else
		debuff3:SetText(debuffstring3)
		debuff3:SetCursorPosition(0)
	end
	if debuffstring4 == nil then
	else
		debuff4:SetText(debuffstring4)
		debuff4:SetCursorPosition(0)
	end
	if debuffstring5 == nil then
	else
		debuff5:SetText(debuffstring5)
		debuff5:SetCursorPosition(0)
	end
	if debuffstring6 == nil then
	else
		debuff6:SetText(debuffstring6)
		debuff6:SetCursorPosition(0)
	end
	if bufflist == nil then
		bufflist = {}
	end
	if debufflist == nil then
		debufflist = {}
	end
	if hideCastWarning ~=nil then
		lookAndFeelHideCastWarning:SetChecked(hideCastWarning)
	end
	if hideBags ~=nil then
		lookAndFeelHideBags:SetChecked(hideBags)
	end
	if hideStance ~=nil then
		lookAndFeelHideStance:SetChecked(hideStance)
	end
	if hideFrameBorders ~= nil then
		lookAndFeelBorderFrame:SetChecked(hideFrameBorders)
	end
	if fixedFramePosition ~= nil then
		lookAndFeelFixedPosition:SetChecked(fixedFramePosition)
	end
	if iconSizeValue ~= nil then
		width = iconSizeValue
		hight = iconSizeValue
	end
	if fontIconSizeValue ~= nil then
		iconFontSize = fontIconSizeValue
	end
	if iconSizeValue ~= nil then
		lookAndFeelIconSize:SetValue(iconSizeValue)
	end
	if fontIconSizeValue ~= nil then
		lookAndFeelFontIconSize:SetValue(fontIconSizeValue)
	end
	if ressource0 ~= nil then
		currentSelectedRessource0 = ressource0
	end
	if ressource1 ~= nil then
		currentSelectedRessource1 = ressource1
	end
	if ressource2 ~= nil then
		currentSelectedRessource2 = ressource2
	end
	if useBrewmasterLookAndFeel ~= nil then
		useBrewmasterLookAndFeelConfig:SetChecked(useBrewmasterLookAndFeel)
	end
	if automaticDebuffCheck ~= nil then
		automaticDebuffCheckFrame:SetChecked(automaticDebuffCheck)
	end

	onLoadProcess = false
	Init(buffListGui)
	debuffInit(debuffListGui)
	lookAndFeelChanged()
	checkForBrewmasterLookAndFeel()
end

function saveAddon()
	if onLoadProcess == true then
		return
	end
	-- DEFAULT_CHAT_FRAME:AddMessage( "saveAddon()" );
	buffstring1 = buff1:GetText()
	buffstring2 = buff2:GetText()
	buffstring3 = buff3:GetText()
	buffstring4 = buff4:GetText()
	buffstring5 = buff5:GetText()
	buffstring6 = buff6:GetText()
	debuffstring1 = debuff1:GetText()
	debuffstring2 = debuff2:GetText()
	debuffstring3 = debuff3:GetText()
	debuffstring4 = debuff4:GetText()
	debuffstring5 = debuff5:GetText()
	debuffstring6 = debuff6:GetText()
	hideCastWarning = lookAndFeelHideCastWarning:GetChecked()
	hideBags = lookAndFeelHideBags:GetChecked()
	hideStance = lookAndFeelHideStance:GetChecked()
	hideFrameBorders = lookAndFeelBorderFrame:GetChecked()
	fixedFramePosition = lookAndFeelFixedPosition:GetChecked()
	iconSizeValue = lookAndFeelIconSize:GetValue()
	fontIconSizeValue = lookAndFeelFontIconSize:GetValue()
	ressource0 = currentSelectedRessource0
	ressource1 = currentSelectedRessource1
	ressource2 = currentSelectedRessource2
	if bufflist == nil then
		bufflist = {}
	end
	if debufflist == nil then
		debufflist = {}
	end
	sort(bufflist, function(a,b) return a.name < b.name end)
	useBrewmasterLookAndFeel = useBrewmasterLookAndFeelConfig:GetChecked()
	automaticDebuffCheck = automaticDebuffCheckFrame:GetChecked()
end


--for _, frame in ipairs({MainMenuBarTexture0, MainMenuBarTexture1, MainMenuBarTexture2, MainMenuBarTexture3, ReputationWatchBarTexture0, ReputationWatchBarTexture1, ReputationXPBarTexture0, ReputationXPBarTexture1, MainMenuBarLeftEndCap, MainMenuBarRightEndCap, MainMenuXPBarTexture0, MainMenuXPBarTexture1, MainMenuMaxLevelBar0, MainMenuMaxLevelBar1, BonusActionBarTexture0, BonusActionBarTexture1}) do 
--	frame:Hide();
--end
--for _, frame in ipairs({PossessBackground1, PossessBackground2, MainMenuBarPageNumber, MainMenuXPBarTexture2, MainMenuXPBarTexture3, MainMenuBarTexture2, MainMenuBarTexture3, ReputationWatchBarTexture2, ReputationWatchBarTexture3, ReputationXPBarTexture2, ReputationXPBarTexture3}) do 
--	frame:Hide();
--end

-- /run for i=1,40 do local n,_,icon,_,_,_,_,_,isStealable,_,spellid=UnitAura("player",i);DEFAULT_CHAT_FRAME:AddMessage( n.. " on target" .. spellid .. ":" .. icon);end;
-- /run for i=1,40 do local name,rank,icon,count,dispellType,duration,expires,caster,isStealable,shouldConsolidate,spellId,canApplyAura,isBossDebuff,value1,value2,value3=UnitDebuff("player",i);DEFAULT_CHAT_FRAME:AddMessage( "V" .. value2 );end;
