local L = Elementarist.Locals;

Elementarist:RegisterModule("enhancement");

Elementarist.enhancement = {
	["Configuration"] = {
		["ShowHealingStream"] = {
			["type"]	=	"CheckBox",
			["label"]	=	L.CONFIG_ENABLE_HS_TOTEM
		}
	};
	Initialize = function(self)
		Elementarist:LoadSpells({
			["Glyph of Flame Shock"] = GetSpellInfo(55447),
			["Healing Stream Totem"] = GetSpellInfo(5394),
			["Maelstrom Weapon"] = GetSpellInfo(51530),
			["Stormstrike"] = GetSpellInfo(17364),
			["Windstrike"] = 115357,		-- not in spellbook, ID must be used!
			["Lava Lash"] = GetSpellInfo(60103),
			["Unleash Flame"] = GetSpellInfo(165462),
			["Unleash Elements"] = GetSpellInfo(73680),
			["Frost Shock"] = GetSpellInfo(8056),
			["Flask of Spring Blossoms"] = GetSpellInfo(76084),
			["AscendanceEnhancementBuff"] = GetSpellInfo(114051),
			["Elemental Fusion"] = GetSpellInfo(157174),
			["Ancestral Swiftness"] = GetSpellInfo(16188),
			["Feral Spirit"] = GetSpellInfo(51533),
			["Fire Nova"] = GetSpellInfo(1535),
			
			["Greater Draenic Agility Flask"] = GetSpellInfo(156064),
			["Draenic Agility Flask"] = GetSpellInfo(156073),
			["Flask of Spring Blossoms"] = GetSpellInfo(114769),
			["Flask of the Winds"] = GetSpellInfo(79471)
		});

		Elementarist.role = "DPS";
		Elementarist.trackAura = Elementarist.SpellList["Flame Shock"];
		Elementarist.trackFilter = "PLAYER|HARMFUL";
		Elementarist.trackDuration = 39;
		Elementarist.trackSpread = false;
		Elementarist.debuffCount = 0;
		Elementarist.exspell1=nil;
	end;
	NextSpell = function(self,timeshift,exspell1,exspell2)
		local guid = UnitGUID("target")
		local currentTime = GetTime()
		local s,d,e
		local name, fsExpiration, unitCaster
		local lastSpell
		local haveFireTotem,fireTotemName,fireTotemStart,fireTotemDuration
		local EBTalent, EETalent, EFTalent, MWcount, EFcount
		local LLCharges, maxLLCharges, cdLLStart, cdLLLength
		local SSCharges, maxSSCharges, cdSSStart, cdSSLength
		local ascendance, ascendanceExp
		local flameshockavail = false
		local spellInCast, sICstartTime, sICendTime
		local _

		EETalent = (Elementarist.tier4Talent == 19273)
		EBTalent = (Elementarist.tier6Talent == 19267)
		Elementarist.exspell1=exspell1

		 _, _, _, MWcount = Elementarist:hasBuff("player",Elementarist.SpellList["Maelstrom Weapon"])
		if (MWcount == nil) then
			MWcount = 0
		end

		 _, _, _, EFcount = Elementarist:hasBuff("player",Elementarist.SpellList["Elemental Fusion"])
		if (EFcount == nil) then
			EFcount = 0
		end

		ascendance, _, _, _, _, _, ascendanceExp = Elementarist:hasBuff("player", Elementarist.SpellList["AscendanceEnhancementBuff"])
		if (ascendance == nil) then
			ascendanceExp = 0
		end

		if (exspell1) then
			if (exspell2) then
				lastSpell = exspell2
			else
				lastSpell = exspell1
			end
		else
			lastSpell = Elementarist.lastSpell
		end
		
		Elementarist.lastBaseGCD = 1.5 - (1.5 * Elementarist.spellHaste * .01)
		
		local LvBct = 2 - (2 * Elementarist.spellHaste * .01)
		
		-- check Shock CD
		s, d = GetSpellCooldown(Elementarist.SpellList["Flame Shock"])
		if (d) and (d>0) and (s == 0) then
			Elementarist.lastShockCD = d
		end
		s, d = GetSpellCooldown(Elementarist.SpellList["Frost Shock"])
		if (d) and (d>0) and (s == 0) then
			Elementarist.lastShockCD = d
		end
		
		-- if target is dead, return ""
		if (UnitHealth("target")<=0) then
			return ""
		end
		
		if (not timeshift) then
			timeshift = 0
		end
		
		-- check current spell
		spellInCast, _, _, _, sICstartTime, sICendTime = UnitCastingInfo("player")
		if (spellInCast) then
			if ( (sICendTime - sICstartTime) / 1000 ) < Elementarist.lastBaseGCD then
				sICendTime = sICstartTime + (Elementarist.lastBaseGCD * 1000)
			end
			timeshift = timeshift + (sICendTime / 1000) - currentTime
		else
			-- no spell in cast, check global cd via Ghost Wolf
			if (Elementarist.SpellList["Ghost Wolf"]) then
				local ftcd = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Ghost Wolf"])
				if (ftcd) then
					timeshift = timeshift + Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Ghost Wolf"])
				else
					timeshift = timeshift + Elementarist.lastBaseGCD
				end
			else
				timeshift = timeshift + Elementarist.lastBaseGCD
			end
		end

		--------------------------- start of priority list ----------------

		----Priority 1 ---  Searing Totem if no fire totem or fire totem about to expire
		if (Elementarist:Count(Elementarist.SpellList["Searing Totem"],spellInCast,exspell1,exspell2) == 0) then
			haveFireTotem,fireTotemName,fireTotemStart,fireTotemDuration = GetTotemInfo(1);
			if (fireTotemName == "") or (fireTotemDuration and (fireTotemStart + fireTotemDuration - currentTime ) -timeshift <= 0) then
				Elementarist:Debug(functionname,  "Priority1",1)
 				return Elementarist.SpellList["Searing Totem"];
			end
		end

		----Priority 2 ---  -- if Tier6 talent is Unleashed Fury then use Unleash Elements
		if (EFTalent) then
			if (Elementaris:Count(Elementarist.SpellList["Unleash Elements"],spellInCast,exspell1,exspell2) == 0) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Unleash Elements"])
				if (d-timeshift <= 0) then
					Elementarist:Debug(functionname, "Priority2",1)
					return Elementarist.SpellList["Unleash Elements"];
				end
			end
		end

		----Priority 3	-- if Tier6 talent is Elemental Blast use it with 5 Maelstrom Weapon stacks (8 with 4 set) 
		if EBTalent then
			if  (
					(  (not Elementarist.hasT18_4pcs) and (MWcount >= 5)) or
					(  (Elementarist.hasT18_4pcs) and (MWcount >= 8))
			)  then
				if (
					(Elementaris:Count(Elementarist.SpellList["Elemental Blast"],spellInCast,exspell1,exspell2) == 0) and
					(IsSpellInRange(Elementarist.SpellList["Elemental Blast"], "target") == 1)
				) then
					d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Elemental Blast"])
					if ((d - timeshift) <= 0) then
						return Elementarist.SpellList["Elemental Blast"]
					end
				end
			end
		end

		----Priority 4	---- Load Windstrike and Stormstrike data
		SSCharges, maxSSCharges, cdSSStart, cdSSLength  = GetSpellCharges(Elementarist.SpellList["Stormstrike"]);
		if (SSCharges<maxSSCharges) and (((cdSSStart + cdSSLength)- currentTime) - timeshift <= 0) then
			SSCharges = SSCharges + 1;
		end
		SSCharges = SSCharges - Elementarist:Count(Elementarist.SpellList["Stormstrike"],spellInCast,exspell1,exspell2);
		SSCharges = SSCharges - Elementarist:Count(Elementarist.SpellList["Windstrike"],spellInCast,exspell1,exspell2);

		--------- Windstrike (requires assendance) at max charges of SS/WS		
		if ascendance then
			if (
					(  SSCharges >= 1) and (not EETalent) or
					( (SSCharges >= 2) ) 
		    ) then
				return Elementarist.SpellList["Windstrike"]
			end
		end

		----Priority 5	-- Cast Lightning Bolt  with 5 Maelstrom Weapon stacks (8 with 4 set) 
		if (
				(  (MWcount >= 5)  and ( not ( Elementarist.hasT18_4pcs)) ) or
		    	(  (MWcount >= 8) ) 
		   ) then
			if (
					(IsSpellInRange(Elementarist.SpellList["Lightning Bolt"], "target") == 1) and
					(Elementarist:Count(Elementarist.SpellList["Lightning Bolt"],exspell1,exspell2) == 0)
			) then
				return Elementarist.SpellList["Lightning Bolt"]
			end
		end

		----Priority 6	-- stormstrike at max charges of SS/WS	
		if (not ascendance) then
			if ( 	(  SSCharges >= 1) and (not EETalent) or
				( (SSCharges >= 2) ) 
				
			    ) then
				return Elementarist.SpellList["Stormstrike"]
			end
		end

		----Priority 7	-- Load Lava Lash Data 
		LLCharges, maxLLCharges, cdLLStart, cdLLLength  = GetSpellCharges(Elementarist.SpellList["Lava Lash"]);
		if (LLCharges<maxLLCharges) and (((cdLLStart + cdLLLength)- currentTime) - timeshift <= 0) then
			LLCharges = LLCharges + 1;
		end
		LLCharges = LLCharges - Elementarist:Count(Elementarist.SpellList["Lava Lash"],spellInCast, exspell1, exspell2);

		-----Lava Lash at max charges of LL
		if (
			(  LLCharges >= 1) and (not EETalent) or
			( (LLCharges >= 2) ) 		
		) then
			return Elementarist.SpellList["Lava Lash"]
		end

		----Priority 8	-- Flame shock if <9 sec remaining and Unleash Flame is up
		name, _, _, _, _, _, fsExpiration, unitCaster = Elementarist:hasDeBuff("target", Elementarist.SpellList["Flame Shock"], "player");
		if (not fsExpiration) then
			fsExpiration = 0
		end
		if (Elementarist:hasBuff("player",Elementarist.SpellList["Unleash Flame"])) and
			(Elementarist:Count(Elementarist.SpellList["Frost Shock"],exspell1,exspell2) == 0) and
			(Elementarist:Count(Elementarist.SpellList["Flame Shock"],exspell1,exspell2) == 0) then
			if IsSpellInRange(Elementarist.SpellList["Flame Shock"], "target") == 1 then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Flame Shock"])
				if (
					(  ((EFcount >= 2) and (d - timeshift) <= 0) and ((fsExpiration - currentTime - timeshift) < 16)     ) or
					(  ((EFcount >= 1) and (d - timeshift) <= 0) and ((fsExpiration - currentTime - timeshift) < 9)    )   or
					(  ((d - timeshift) <= 0) and ((fsExpiration - currentTime - timeshift) < 9)    )
				    )	then
					return Elementarist.SpellList["Flame Shock"]
				end
			end
		end
	
		-- Priority 9 : Unleash Elements
		if (Elementarist:Count(Elementarist.SpellList["Unleash Elements"],spellInCast,exspell1,exspell2) == 0) then
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Unleash Elements"])
			if ((d - timeshift) <= 0) then
				return Elementarist.SpellList["Unleash Elements"]
			end
		end

		-- Priority 10	: Windstrike (requires assendance) at 1 charges of SS/WS with EETalent		
		if ascendance then
			if ( (SSCharges >= 1) and (EETalent) ) then
				return Elementarist.SpellList["Windstrike"]
			end
		end

		-- Priority 11 : check Elemental Blast is available first
		if EBTalent then
			if 	(
				(Elementarist:Count(Elementarist.SpellList["Elemental Blast"],spellInCast,exspell1,exspell2) == 0) and
				(IsSpellInRange(Elementarist.SpellList["Elemental Blast"], "target") == 1)
			) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Elemental Blast"])
				-- Elemental Blast (Tier 6 Talent) with Anscestral Swiftness buff 
				if ((d - timeshift) <= 0) then
  					if Elementarist:hasBuff("player", Elementarist.SpellList["Ancestral Swiftness"]) then
						return Elementarist.SpellList["Elemental Blast"]
					end
				end
			end

			-- Elemental Blast (Tier 6 Talent) with T18 4 set and 3 or More Maelstrom Weapon
			if  ( (Elementarist.hasT18_4pcs) and (MWcount >= 3) ) then
				if ((d - timeshift) <= 0) then
					return Elementarist.SpellList["Elemental Blast"]
				end
			end
		end

		-- Priority 12 : lightning bolt near max count or with Ancesteral swiftness (only if not using T18 4 set)
		if ( not  Elementarist.hasT18_4pcs) then
			if (
				((MWcount >=3 ) and (not ascendance)) or 
				Elementarist:hasBuff("player", Elementarist.SpellList["Ancestral Swiftness"]) 
			) then
				return Elementarist.SpellList["Lightning Bolt"]
			end
		end

		-- Priority 13 : Lava Lash at 1 charge with Echo of the elements
		if ((  LLCharges >= 1) and EETalent) then
			return Elementarist.SpellList["Lava Lash"]
		end


		-- Priority 14 : Frost Shock if not using Elemental Fusion or if more than 16 seconds remaining on Flame Shock debuff
		d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Frost Shock"])
		if (
			((d - timeshift) <= 0) and
			(Elementarist:Count(Elementarist.SpellList["Frost Shock"],exspell1,exspell2) == 0) and
			(Elementarist:Count(Elementarist.SpellList["Flame Shock"],exspell1,exspell2) == 0)
		) then
			if (EFTalent and ((fsExpiration - currentTime - timeshift) < 16)) or (not EFTalent) then 
				return Elementarist.SpellList["Frost Shock"]
			end
		end

		-- Priority 15 : Elemental Blast if T18 4 piece and 2 or more Maelstom Weapon
		if EBTalent and Elementarist.hasT18_4pcs and (MWcount >=2) then
			if 	(
				(Elementarist:Count(Elementarist.SpellList["Elemental Blast"],spellInCast,exspell1,exspell2) == 0) and
				(IsSpellInRange(Elementarist.SpellList["Elemental Blast"], "target") == 1)
	    	) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Elemental Blast"])
				if ((d - timeshift) <= 0) then
  					if Elementarist:hasBuff("player", Elementarist.SpellList["Ancestral Swiftness"]) then
						return Elementarist.SpellList["Elemental Blast"]
					end
				end
			end

		end

		-- Priority 16
		if ( EETalent and (not Elementarist.hasT18_4pcs) and (MWcount >=2) ) then 
			return Elementarist.SpellList["Lightning Bolt"]   
		end

		-- Priority 17 : storm strike if using Echo of Elements
		if (not ascendance) then
			if ((SSCharges >= 1) and EETalent ) then
				return Elementarist.SpellList["Stormstrike"]
			end
		end

		-- Priority 18 : Lighnting bolt at low charges of Maelstrom weapon 
		if (
			(Elementarist.hasT18_4pcs and (MWcount >=3)) or (MWcount >= 1)
		) then
			if IsSpellInRange(Elementarist.SpellList["Lightning Bolt"], "target") == 1 then
				return Elementarist.SpellList["Lightning Bolt"]
			end
		end

		-- Priority 19 : Searing Totem if less than 20 seconds until it expires
		if (Elementarist:Count(Elementarist.SpellList["Searing Totem"],spellInCast,exspell1,exspell2) == 0) then
			if (fireTotemName == "") or (fireTotemDuration and (fireTotemStart + fireTotemDuration - currentTime ) -timeshift <= 20) then
 				return Elementarist.SpellList["Searing Totem"];
			end
		end

		-- Last Priority : if nothing else lighting bolt for the win!
		return Elementarist.SpellList["Lightning Bolt"]
	end;
	MiscSpell = function(self)
		-- Miscelaneous spell order:
		-- Lightning Shield
		-- Searing Totem
		-- Berserking troll racial (if available)
		-- Blood Fury orc racial
	
		local d, e
		local name, expirationTime, _, name2, expirationTime2, name3, expirationTime3

		------  Augment Rune
		if (
			(
				((Elementarist.faction == "Horde") and (GetItemCount(Elementarist.CustomIDs["Empowered Augment Rune Horde"]) ~= 0)) or
				((Elementarist.faction == "Alliance") and (GetItemCount(Elementarist.CustomIDs["Empowered Augment Rune Alliance"]) ~= 0))
			) and ( not  Elementarist:hasBuff("player", Elementarist.SpellList["Hyper Augmentation"]))
		) then
        	if (
        		((Elementarist.faction == "Horde") and (Elementarist:GetItemCooldownRemaining(Elementarist.CustomIDs["Empowered Augment Rune Horde"]) < 2)) or
        		((Elementarist.faction == "Alliance") and (Elementarist:GetItemCooldownRemaining(Elementarist.CustomIDs["Empowered Augment Rune Alliance"]) < 2))
        	) then
				return nil,GetItemIcon(Elementarist.CustomIDs["Empowered Augment Rune Horde"])
			end
       	end

		-- Alchemy Flask of Enhancement
		if	(
			((GetItemCount(Elementarist.CustomIDs["Whispers of Insanity Item"]) ~= 0) and (Elementarist.playerLevel >= 90)  ) or
			((GetItemCount(Elementarist.CustomIDs["Crystal of Insanity Item"]) ~= 0)and (Elementarist.playerLevel >= 85)  ) or
			((GetItemCount(Elementarist.CustomIDs["Alchemist's Flask Item"]) ~= 0)  and (Elementarist.playerLevel <= 91)  )
		) then
			name = Elementarist:hasBuff("player", Elementarist.SpellList["Greater Draenic Agility Flask"]);
			if (name == nil) then
				name = Elementarist:hasBuff("player", Elementarist.SpellList["Draenic Agility Flask"]);
			end
			if (name == nil) then
				name = Elementarist:hasBuff("player", Elementarist.SpellList["Flask of Spring Blossoms"]);
			end
			if (name == nil) then
				name = Elementarist:hasBuff("player", Elementarist.SpellList["Flask of the Winds"]);
			end
			if (name == nil) then
				name,  _, _, _, _, _, expirationTime = Elementarist:hasBuff("player", Elementarist.SpellList["Whispers of Insanity"], false, Elementarist.CustomIDs["Whispers of Insanity Spell"]);
				name2, _, _, _, _, _, expirationTime2 = Elementarist:hasBuff("player", Elementarist.SpellList["Crystal of Insanity"], false, Elementarist.CustomIDs["Crystal of Insanity Spell"]);
				name3, _, _, _, _, _, expirationTime3 = Elementarist:hasBuff("player", Elementarist.SpellList["Alchemist's Flask"], false, Elementarist.CustomIDs["Alchemist's Flask Spell"]);
				
				if ((name == nil) and (name2 == nil) and (name3 == nil)) or (((name ~= nil) and (expirationTime<2)) or ((name2 ~= nil) and (expirationTime2<2)) or ((name3 ~= nil) and (expirationTime3<2))) then
					if (GetItemCount(Elementarist.CustomIDs["Whispers of Insanity Item"]) ~= 0) then
						local itemCooldown = Elementarist:GetItemCooldownRemaining(Elementarist.CustomIDs["Whispers of Insanity Item"]);
						if ((name == nil) or (expirationTime < 2)) and (itemCooldown < 1) then
							return nil,GetItemIcon(Elementarist.CustomIDs["Whispers of Insanity Item"])
						end
					elseif (GetItemCount(Elementarist.CustomIDs["Crystal of Insanity Item"]) ~= 0) then
						local itemCooldown = Elementarist:GetItemCooldownRemaining(Elementarist.CustomIDs["Crystal of Insanity Item"]);
						if ((name == nil) or (expirationTime < 2)) and (itemCooldown < 1) then
							return nil,GetItemIcon(Elementarist.CustomIDs["Crystal of Insanity Item"])
						end
					elseif (GetItemCount(Elementarist.CustomIDs["Alchemist's Flask Item"]) ~= 0) then
						local itemCooldown = Elementarist:GetItemCooldownRemaining(Elementarist.CustomIDs["Alchemist's Flask Item"]);
						if ((name == nil) or (expirationTime < 2)) and (itemCooldown < 1) then
							return nil,GetItemIcon(Elementarist.CustomIDs["Alchemist's Flask Item"])
						end
					end
				end
			end
		end

		-- Lightning Shield
		if Elementarist:SpellAvailable(Elementarist.SpellList["Lightning Shield"]) then
			name, _, _, _, _, _, expirationTime = Elementarist:hasBuff("player", Elementarist.SpellList["Lightning Shield"]);
			if (name == nil) or (expirationTime < 1) then
				return Elementarist.SpellList["Lightning Shield"]
			end
		end

		-- Fire Elemental Totem
		if Elementarist:SpellAvailable(Elementarist.SpellList["Fire Elemental Totem"]) then
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Fire Elemental Totem"])
			if d <= 0.5 then
				return Elementarist.SpellList["Fire Elemental Totem"]
			end
		end

		-- Liquid Magma if not in rotation and Tier7 talent is Liquid Magma and fire totem has 10 sec or more
		if (Elementarist.tier7Talent == 21200) and (ElementaristDB.DisableLM) then
			local haveFireTotem,fireTotemName,fireTotemStart,fireTotemDuration = GetTotemInfo(1);
			if (fireTotemName ~= "") and (fireTotemDuration and (fireTotemStart + fireTotemDuration - GetTime() ) >= 10) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Liquid Magma"])
				if (d<=0.5) then
					return Elementarist.SpellList["Liquid Magma"]
				end
			end
		end

		-- Storm Elemental Totem
		if (Elementarist.tier7Talent == 21199) then	
			if Elementarist:SpellAvailable(Elementarist.SpellList["Storm Elemental Totem"]) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Storm Elemental Totem"])
				if d <= 0.5 then
					return Elementarist.SpellList["Storm Elemental Totem"]
				end
			end
		end

		-- Healing Stream Totem
		if (ElementaristDB.ShowHealingStream) and (Elementarist:SpellAvailable(Elementarist.SpellList["Healing Stream Totem"])) then
			local haveWaterTotem,waterTotemName,_,_ = GetTotemInfo(3)
			if (waterTotemName == "") then
				e = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Healing Stream Totem"]);
				if (e < 1) then
					return Elementarist.SpellList["Healing Stream Totem"];
				end;
			end
		end


		-- Feral Spirit
		if Elementarist:SpellAvailable(Elementarist.SpellList["Feral Spirit"]) then
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Feral Spirit"])
			if d <= 0.5 then
				return Elementarist.SpellList["Feral Spirit"]
			end
		end
	
		-- Elemental Mastery
		if Elementarist:SpellAvailable(Elementarist.SpellList["Elemental Mastery"]) then
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Elemental Mastery"])
			if d <= 0.5 then
				return Elementarist.SpellList["Elemental Mastery"]
			end
		end
	
		-- Ascendance
		if Elementarist:SpellAvailable(Elementarist.SpellList["Ascendance"]) then
			name = Elementarist:hasBuff("player",Elementarist.SpellList["AscendanceElementalBuff"])
			if (name == nil) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Ascendance"])
				if d <= 0.5 then
					return Elementarist.SpellList["Ascendance"]
				end
			end
		end

		-- Berserking
		if Elementarist:SpellAvailable(Elementarist.SpellList["Berserking"]) then
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Berserking"])
			if d <= 0.5 then
				return Elementarist.SpellList["Berserking"]
			end
		end
	
		-- Blood Fury
		if Elementarist:SpellAvailable(Elementarist.SpellList["Blood Fury"]) then
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Blood Fury"])
			if d <= 0.5 then
				return Elementarist.SpellList["Blood Fury"]
			end
		end

		return ""
	end;
	IntSpell = function(self)
		-- interruptions, purge, and AoE on target
		local d
		
		Elementarist.trackSpread = (Elementarist.lastSpell == Elementarist.SpellList["Flame Shock"])
		
		-- AOE at least 3 enemies
 		if (Elementarist.person["foeCount"]>=3) then
			-- Searing Totem if no fire totem or fire totem about to expire
			local haveFireTotem,fireTotemName,fireTotemStart,fireTotemDuration = GetTotemInfo(1);
			if (
				(fireTotemName == "") or (fireTotemName == "Searing Totem") or
				(fireTotemDuration and (fireTotemStart + fireTotemDuration - GetTime() ) <= 0)
			) then
				return Elementarist.SpellList["Magma Totem"];
			end

			-- Liquid  if not in rotation and Tier7 talent is Liquid Magma and fire totem has 10 sec or more
			if (Elementarist.tier7Talent == 21200) then
				if (fireTotemName ~= "") and (fireTotemDuration and (fireTotemStart + fireTotemDuration - GetTime() ) >= 10) then
					d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Liquid Magma"])
					if (d<=0.5) then
						return Elementarist.SpellList["Liquid Magma"]
					end
				end
			end

			-- Flame shock if <9 sec remaining and Unleash Flame is up
			local name, _, _, _, _, _, fsExpiration, unitCaster = Elementarist:hasDeBuff("target", Elementarist.SpellList["Flame Shock"], "player");
			if (not fsExpiration) then
				fsExpiration = 0
			end
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Flame Shock"])
			if (d <= 0.5) and (fsExpiration - GetTime() < 9) then
				return Elementarist.SpellList["Flame Shock"]
			end

			if Elementarist.trackSpread then
				local LLCharges, maxLLCharges, cdLLStart, cdLLLength  = GetSpellCharges(Elementarist.SpellList["Lava Lash"]);
				if (LLCharges > 0) then
					return Elementarist.SpellList["Lava Lash"]
				end
			end
	
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Fire Nova"])
			if ((d ) <= 0.5) then
				return Elementarist.SpellList["Fire Nova"]
			end

			---- Chain Lightning in place of Lightning Bolt
			if Elementarist.exspell1 == Elementarist.SpellList["Lightning Bolt"] then
				if Elementarist:SpellAvailable(Elementarist.SpellList["Chain Lightning"]) then
					return Elementarist.SpellList["Chain Lightning"]
				end
			end

			return Elementarist.exspell1
		end

        -- Wind Shear
		if Elementarist:SpellAvailable(Elementarist.SpellList["Wind Shear"]) then
			if IsSpellInRange(Elementarist.SpellList["Wind Shear"], "target") == 1 then
				local _, status, threatpct, _, _ = UnitDetailedThreatSituation("player", "target")
				if ((UnitCastingInfo("target")) or (UnitChannelInfo("target"))) or ((status) and (threatpct>80) and (Elementarist.person["friendCount"]>1) and (Elementarist.inParty>0)) then
					d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Wind Shear"])
					if (d) and (d<0.5) and (IsSpellInRange(Elementarist.SpellList["Wind Shear"], "target") ) then
						return Elementarist.SpellList["Wind Shear"]
					end
				end
			
				if (UnitChannelInfo("target")) then
					d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Wind Shear"])
					if (d<0.5) and (interruptable) and (IsSpellInRange(Elementarist.SpellList["Wind Shear"], "target") ) then
						return Elementarist.SpellList["Wind Shear"]
					end
				end
			end
		end

		---------- check if purgeable buff is on target (not sure if this is ok)
		if Elementarist:SpellAvailable(Elementarist.SpellList["Purge"]) then
			if IsSpellInRange(Elementarist.SpellList["Purge"], "target") == 1 then
				if (Elementarist:hasBuff("target", ".", 1)) then
					d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Purge"])
					if (d) and (d<0.5) then
						return Elementarist.SpellList["Purge"]
					end
				end
			end
		end
	
		return ""
	end;
	ShieldName = function(self)
		return "Lightning Shield";
	end;
};
