local L = Elementarist.Locals;

Elementarist:RegisterModule("elemental");

Elementarist.elemental = {
	["Configuration"] = {
		["Behavior"] = {
			["type"]	= "DropDown",
			["label"]	=	L.CONFIG_BEHAVIOR,
			["options"]	= {
				{text	=	L.BEHAVIOR_KEEP_FS_UP},
				{text	=	L.BEHAVIOR_FS_BEFORE_LVB}
			}
		},
		["EnableEQ"] = {
			["type"]	=	"CheckBox",
			["label"]	=	L.CONFIG_ENABLE_EQ_SPELL
		},
		["ShowHealingStream"] = {
			["type"]	=	"CheckBox",
			["label"]	=	L.CONFIG_ENABLE_HS_TOTEM
		},
		["DisableLM"] = {
			["type"]	=	"CheckBox",
			["label"]	=	L.CONFIG_DISABLE_LM_SPELL
		},
	};
	Initialize = function(self)
		Elementarist:LoadSpells({
			["Glyph of Flame Shock"] = GetSpellInfo(55447),
			["Healing Stream Totem"] = GetSpellInfo(5394),
			["Liquid Magma"] = GetSpellInfo(152255),
			["Enhanced Chain Lightning"]  = GetSpellInfo(157766),
			["Storm Elemental Totem"] = GetSpellInfo(152256)
		});

		Elementarist.role = "DPS";
		Elementarist.trackAura = Elementarist.SpellList["Flame Shock"];
		Elementarist.trackFilter = "PLAYER|HARMFUL";
		Elementarist.trackDuration = 39;
	end;
	NextSpell = function(self,timeshift,exspell1,exspell2)
		local guid = UnitGUID("target")
		local currentTime = GetTime()
		local s,d,e
		local name, fsExpiration, unitCaster
		local haveFireTotem,fireTotemName,fireTotemStart,fireTotemDuration
		local lastSpell
		local doFS = false
		local _
		local lscount

		if (exspell1) then
			if (exspell2) then
				lastSpell = exspell2
			else
				lastSpell = exspell1
			end
		else
			lastSpell = Elementarist.lastSpell
		end
		
		Elementarist.lastBaseGCD = 1.5 - (1.5 * Elementarist.spellHaste * .01)
		
		local flameshockavail = false
		local LvBct = 2 - (2 * Elementarist.spellHaste * .01)
		
		-- check Shock CD
		s, d = GetSpellCooldown(Elementarist.SpellList["Flame Shock"])
		if (d) and (d>0) and (s == 0) then
			Elementarist.lastShockCD = d
		end
		s, d = GetSpellCooldown(Elementarist.SpellList["Earth Shock"])
		if (d) and (d>0) and (s == 0) then
			Elementarist.lastShockCD = d
		end
		_, _, _, lscount = Elementarist:hasBuff("player",Elementarist.SpellList["Lightning Shield"])
		
		-- if target is dead, return ""
		if (UnitHealth("target")<=0) then
			return ""
		end
		
		if (not timeshift) then
			timeshift = 0
		end
		
		-- check current spell
		local spellInCast, _, _, _, sICstartTime, sICendTime = UnitCastingInfo("player")

		if (spellInCast) then
			if ( (sICendTime - sICstartTime) / 1000 ) < Elementarist.lastBaseGCD then
				sICendTime = sICstartTime + (Elementarist.lastBaseGCD * 1000)
			end
			Elementarist.lastCastTime = sICendTime;
			timeshift = timeshift + (sICendTime / 1000) - GetTime()
		else
			-- to prevent tick in current spell, check if last one finished in short time
			if (Elementarist.lastCastTime) and ((Elementarist.lastCastTime / 1000) + Elementarist.lastBaseGCD >= GetTime() ) then
				spellInCast = Elementarist.lastSpell;
			end
			-- no spell in cast, check global cd via Ghost Wolf
			if (Elementarist.SpellList["Ghost Wolf"]) then
				local ftcd = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Ghost Wolf"])
				if (ftcd) then
					timeshift = timeshift + Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Ghost Wolf"])
				else
					timeshift = timeshift + Elementarist.lastBaseGCD
				end
			else
				timeshift = timeshift + Elementarist.lastBaseGCD
			end
		end

		-- if item level >575 and Earthquake is enabled
		if (ElementaristDB.EnableEQ) then
			if (Elementarist.iLvl>=575) or (Elementarist.person["foeCount"]>1) then
				local eqCharges, maxEqCharges, cdStart, cdLength  = GetSpellCharges(Elementarist.SpellList["Earthquake"]);
				if (eqCharges<maxEqCharges) and (((cdStart + cdLength)- GetTime()) - timeshift <= 0) then
					eqCharges = eqCharges + 1;
				end
				eqCharges = eqCharges - Elementarist:Count(Elementarist.SpellList["Earthquake"],spellInCast,exspell1,exspell2);
				if (eqCharges > 0) then
					d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Earthquake"])
					if (d) and (d<0.5) then
						return Elementarist.SpellList["Earthquake"]
					end
				end
			end
		end
		
		-- if Tier7 talent is Liquid Magma and fire totem has 10 sec or more, use it
		if (Elementarist.tier7Talent == 21200) and (not ElementaristDB.DisableLM) then
			if (Elementarist:Count(Elementarist.SpellList["Liquid Magma"],spellInCast,exspell1,exspell2) == 0) then
				haveFireTotem,fireTotemName,fireTotemStart,fireTotemDuration = GetTotemInfo(1);
				if ((fireTotemName ~= "") and (fireTotemDuration and (fireTotemStart + fireTotemDuration - GetTime() ) >= timeshift + 15)) or 
					(Elementarist:Count(Elementarist.SpellList["Searing Totem"],spellInCast,exspell1,exspell2) ~= 0) then
					d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Liquid Magma"])
					if (d-timeshift <= 0) then
						return Elementarist.SpellList["Liquid Magma"]
					end
				else
					if (Elementarist:Count(Elementarist.SpellList["Searing Totem"],spellInCast,exspell1,exspell2) == 0) and
						((fireTotemName == "") or (fireTotemDuration and (fireTotemStart + fireTotemDuration - GetTime() ) <= timeshift))
					then
						return Elementarist.SpellList["Searing Totem"];
					end
				end
			end
		end

		-- check if Flame shock applied on target first
		name, _, _, _, _, _, fsExpiration, unitCaster = Elementarist:hasDeBuff("target", Elementarist.SpellList["Flame Shock"], "player");
		if (not fsExpiration) then
			fsExpiration = 0
		end
		if (Elementarist:Count(Elementarist.SpellList["Flame Shock"],spellInCast,exspell1,exspell2) == 0 and Elementarist:Count(Elementarist.SpellList["Earth Shock"],spellInCast,exspell1,exspell2) == 0) then
			if IsSpellInRange(Elementarist.SpellList["Flame Shock"], "target") == 1 then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Flame Shock"])
				if ((d - timeshift) <= 0) then
					flameshockavail = true
					if (unitCaster ~= "player") then	-- fs debuff is not casted by the player
						name = false
						fsExpiration = 0
					end
					if (not name) then 	-- no fs debuff on target
						fsExpiration = 0
					end
					if (ElementaristDB.Behavior == Elementarist.Behaviors["1"]) then
						doFS = true
					else	-- if fs before lvb, check lvb cd
						d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Lava Burst"])
						if (d) and (d <= (timeshift + Elementarist.lastBaseGCD)) then
							doFS = true
						end
					end
					if (doFS) and ((fsExpiration - GetTime() - timeshift) < 2 * Elementarist.lastBaseGCD) then
						return Elementarist.SpellList["Flame Shock"]
					end
				end
			end
		end

		-- Earth shock if Lightning Shield count >=20 
		if (Elementarist:Count(Elementarist.SpellList["Flame Shock"],spellInCast,exspell1,exspell2) == 0 and Elementarist:Count(Elementarist.SpellList["Earth Shock"],spellInCast,exspell1,exspell2) == 0) then
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Earth Shock"])
			if ( (d) and ((d-timeshift) <= 0) and (lscount) and (lscount>=20)) then
				return Elementarist.SpellList["Earth Shock"]
			end
		end

		-- Lava Burst if not on Cooldown
		local ascendance, _, _, _, _, _, ascendanceExp = Elementarist:hasBuff("player",Elementarist.SpellList["AscendanceElementalBuff"]);
		if (ascendance == nil) then
			ascendanceExp = 0
		end
		local lvbCharges, maxLvbCharges, cdStart, cdLength  = GetSpellCharges(Elementarist.SpellList["Lava Burst"]);
		if (lvbCharges<maxLvbCharges) and (((cdStart + cdLength)- GetTime()) - timeshift <= 0) then
			lvbCharges = lvbCharges + 1;
		end
		lvbCharges = lvbCharges - Elementarist:Count(Elementarist.SpellList["Lava Burst"],spellInCast,exspell1,exspell2);

		if (
			(lvbCharges > 0)
			or
			((ascendanceExp-GetTime()-timeshift) > 0)
		) then
			if (IsSpellInRange(Elementarist.SpellList["Flame Shock"], "target") == 1) and
			(
				((fsExpiration~=0) and ((fsExpiration-GetTime()-timeshift) > LvBct)) or 
				(Elementarist:Count(Elementarist.SpellList["Flame Shock"],spellInCast,exspell1,exspell2) > 0)
			) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Lava Burst"])
				if ((d-timeshift) <= 0) or ((ascendanceExp-GetTime()-timeshift) > 0) then
					return Elementarist.SpellList["Lava Burst"]
				end
			end
		end
	
		-- Earth shock if Lightning Shield count >=17 and not on cd, and FS debuff remaining > FS cooldown, or FS debuff remaining between FS and FS cd + 2sec and LS count>=13, or has T17 4pcs and LS Count >= 12
		if (Elementarist:Count(Elementarist.SpellList["Flame Shock"],spellInCast,exspell1,exspell2) == 0 and Elementarist:Count(Elementarist.SpellList["Earth Shock"],spellInCast,exspell1,exspell2) == 0) then
			if ( (fsExpiration - GetTime() - timeshift) > Elementarist.lastShockCD ) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Earth Shock"])
				if (
					( (d) and ((d-timeshift) <= 0) and (lscount) ) and (	-- Earth Shock is available, and has lightning shield
						(lscount>=17) or 														-- Lightning shield has 17 charge
						( (lscount>=13) and ( (fsExpiration - GetTime() - timeshift) < Elementarist.lastShockCD + 2 ) ) or	-- or, has 13 or more charges but FS expiration within 2 secs to FS CD
						( (lscount>=12) and Elementarist.hasT17_4pcs) -- or has T17 4pcs bonus, and 12 or more charges on LS
					)
				) then
					return Elementarist.SpellList["Earth Shock"]
				end
			end
		end

		-- Searing Totem
		if (Elementarist:Count(Elementarist.SpellList["Searing Totem"],spellInCast,exspell1,exspell2) == 0) then
			local haveFireTotem,fireTotemName,fireTotemStart,fireTotemDuration = GetTotemInfo(1);
			if (fireTotemName == "") or (fireTotemDuration and (fireTotemStart + fireTotemDuration - GetTime() ) <= timeshift) then
 				return Elementarist.SpellList["Searing Totem"];
			end
		end

		-- if Tier6 talent is Elemental Blast use it
		if (Elementarist.tier6Talent == 19267) then
			if (
				(Elementarist:Count(Elementarist.SpellList["Elemental Blast"],spellInCast,exspell1,exspell2) == 0) and
				(IsSpellInRange(Elementarist.SpellList["Elemental Blast"], "target") == 1)
			) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Elemental Blast"])
				if ((d - timeshift) <= 0) then
					return Elementarist.SpellList["Elemental Blast"]
				end
			end
		end

		-- if Tier6 talent is Unleashed Fury Unleash Flame
		if (Elementarist.tier6Talent == 21773) then
			if (Elementarist:Count(Elementarist.SpellList["Unleash Flame"],spellInCast,exspell1,exspell2) == 0) then
				e = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Unleash Flame"])
				if (e-timeshift <= 0) then
					return Elementarist.SpellList["Unleash Flame"];
				end
			end
		end

		-- refresh FS
		if 	(Elementarist:Count(Elementarist.SpellList["Flame Shock"],spellInCast,exspell1,exspell2) == 0) then 
			if (doFS) and ((fsExpiration - GetTime() - timeshift) < 9) then
				return Elementarist.SpellList["Flame Shock"]
			end
		end

		-- otherwise lightning bolt
		if IsSpellInRange(Elementarist.SpellList["Lightning Bolt"], "target") == 1 then
			return Elementarist.SpellList["Lightning Bolt"]
		end
		
		-- if nothing works, try flameshock again
		if flameshockavail then
			return Elementarist.SpellList["Flame Shock"]
		end
		
		return ""
	end;
	MiscSpell = function(self)
		-- Miscelaneous spell order:
		-- Lightning Shield
		-- Searing Totem
		-- Elemental Mastery
		-- Berserking troll racial (if available)
		-- Blood Fury orc racial
	
		local d, e
		local name, expirationTime, _, name2, expirationTime2, name3, expirationTime3
		
		------  Augment Rune
		if (
			(
				((Elementarist.faction == "Horde") and (GetItemCount(Elementarist.CustomIDs["Empowered Augment Rune Horde"]) ~= 0)) or
				((Elementarist.faction == "Alliance") and (GetItemCount(Elementarist.CustomIDs["Empowered Augment Rune Alliance"]) ~= 0))
			) and ( not  Elementarist:hasBuff("player", Elementarist.SpellList["Focus Augmentation"]))
		) then
        	if (
        		((Elementarist.faction == "Horde") and (Elementarist:GetItemCooldownRemaining(Elementarist.CustomIDs["Empowered Augment Rune Horde"]) < 2)) or
        		((Elementarist.faction == "Alliance") and (Elementarist:GetItemCooldownRemaining(Elementarist.CustomIDs["Empowered Augment Rune Alliance"]) < 2))
        	) then
				return nil,GetItemIcon(Elementarist.CustomIDs["Empowered Augment Rune Horde"])
			end
       	end

		-- Alchemy Flask of Enhancement
		if	(
			((GetItemCount(Elementarist.CustomIDs["Whispers of Insanity Item"]) ~= 0) and (Elementarist.playerLevel >= 90)  ) or
			((GetItemCount(Elementarist.CustomIDs["Crystal of Insanity Item"]) ~= 0)and (Elementarist.playerLevel >= 85)  ) or
			((GetItemCount(Elementarist.CustomIDs["Alchemist's Flask Item"]) ~= 0)  and (Elementarist.playerLevel <= 91)  )
		) then
			name = Elementarist:hasBuff("player", Elementarist.SpellList["Greater Draenic Intellect Flask"]);
			if (name == nil) then
				name = Elementarist:hasBuff("player", Elementarist.SpellList["Draenic Intellect Flask"]);
			end
			if (name == nil) then
				name = Elementarist:hasBuff("player", Elementarist.SpellList["Flask of the Warm Sun"]);
			end
			if (name == nil) then
				name = Elementarist:hasBuff("player", Elementarist.SpellList["Flask of the Draconic Mind"]);
			end
			if (name == nil) then
				name,  _, _, _, _, _, expirationTime = Elementarist:hasBuff("player", Elementarist.SpellList["Whispers of Insanity"], false, Elementarist.CustomIDs["Whispers of Insanity Spell"]);
				name2, _, _, _, _, _, expirationTime2 = Elementarist:hasBuff("player", Elementarist.SpellList["Crystal of Insanity"], false, Elementarist.CustomIDs["Crystal of Insanity Spell"]);
				name3, _, _, _, _, _, expirationTime3 = Elementarist:hasBuff("player", Elementarist.SpellList["Alchemist's Flask"], false, Elementarist.CustomIDs["Alchemist's Flask Spell"]);
				
				if ((name == nil) and (name2 == nil) and (name3 == nil)) or (((name ~= nil) and (expirationTime<2)) or ((name2 ~= nil) and (expirationTime2<2)) or ((name3 ~= nil) and (expirationTime3<2))) then
					if (GetItemCount(Elementarist.CustomIDs["Whispers of Insanity Item"]) ~= 0) then
						local itemCooldown = Elementarist:GetItemCooldownRemaining(Elementarist.CustomIDs["Whispers of Insanity Item"]);
						if ((name == nil) or (expirationTime < 2)) and (itemCooldown < 1) then
							return nil,GetItemIcon(Elementarist.CustomIDs["Whispers of Insanity Item"])
						end
					elseif (GetItemCount(Elementarist.CustomIDs["Crystal of Insanity Item"]) ~= 0) then
						local itemCooldown = Elementarist:GetItemCooldownRemaining(Elementarist.CustomIDs["Crystal of Insanity Item"]);
						if ((name == nil) or (expirationTime < 2)) and (itemCooldown < 1) then
							return nil,GetItemIcon(Elementarist.CustomIDs["Crystal of Insanity Item"])
						end
					elseif (GetItemCount(Elementarist.CustomIDs["Alchemist's Flask Item"]) ~= 0) then
						local itemCooldown = Elementarist:GetItemCooldownRemaining(Elementarist.CustomIDs["Alchemist's Flask Item"]);
						if ((name == nil) or (expirationTime < 2)) and (itemCooldown < 1) then
							return nil,GetItemIcon(Elementarist.CustomIDs["Alchemist's Flask Item"])
						end
					end
				end
			end
		end

		-- Lightning Shield
		if Elementarist:SpellAvailable(Elementarist.SpellList["Lightning Shield"]) then
			name, _, _, _, _, _, expirationTime = Elementarist:hasBuff("player", Elementarist.SpellList["Lightning Shield"]);
			if (name == nil) or (expirationTime < 1) then
				return Elementarist.SpellList["Lightning Shield"]
			end
		end
		
		-- Fire Elemental Totem
		if Elementarist:SpellAvailable(Elementarist.SpellList["Fire Elemental Totem"]) then
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Fire Elemental Totem"])
			if d <= 0.5 then
				return Elementarist.SpellList["Fire Elemental Totem"]
			end
		end

		-- Storm Elemental Totem
		if (Elementarist.tier7Talent == 21199) then	
			if Elementarist:SpellAvailable(Elementarist.SpellList["Storm Elemental Totem"]) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Storm Elemental Totem"])
				if d <= 0.5 then
					return Elementarist.SpellList["Storm Elemental Totem"]
				end
			end
		end

		-- Liquid Magma if not in rotation and Tier7 talent is Liquid Magma and fire totem has 10 sec or more
		if (Elementarist.tier7Talent == 21200) and (ElementaristDB.DisableLM) then
			local haveFireTotem,fireTotemName,fireTotemStart,fireTotemDuration = GetTotemInfo(1);
			if (fireTotemName ~= "") and (fireTotemDuration and (fireTotemStart + fireTotemDuration - GetTime() ) >= 10) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Liquid Magma"])
				if (d<=0.5) then
					return Elementarist.SpellList["Liquid Magma"]
				end
			end
		end

		-- Healing Stream Totem
		if (ElementaristDB.ShowHealingStream) and (Elementarist:SpellAvailable(Elementarist.SpellList["Healing Stream Totem"])) then
			local haveWaterTotem,waterTotemName,_,_ = GetTotemInfo(3)
			if (waterTotemName == "") then
				e = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Healing Stream Totem"]);
				if (e < 1) then
					return Elementarist.SpellList["Healing Stream Totem"];
				end;
			end
		end

		-- Elemental Mastery
		if Elementarist:SpellAvailable(Elementarist.SpellList["Elemental Mastery"]) then
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Elemental Mastery"])
			if d <= 0.5 then
				return Elementarist.SpellList["Elemental Mastery"]
			end
		end
	
		-- Ascendance
		if Elementarist:SpellAvailable(Elementarist.SpellList["Ascendance"]) then
			name = Elementarist:hasBuff("player",Elementarist.SpellList["AscendanceElementalBuff"])
			if (name == nil) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Ascendance"])
				if d <= 0.5 then
					return Elementarist.SpellList["Ascendance"]
				end
			end
		end

		-- Berserking
		if Elementarist:SpellAvailable(Elementarist.SpellList["Berserking"]) then
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Berserking"])
			if d <= 0.5 then
				return Elementarist.SpellList["Berserking"]
			end
		end
	
		-- Blood Fury
		if Elementarist:SpellAvailable(Elementarist.SpellList["Blood Fury"]) then
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Blood Fury"])
			if d <= 0.5 then
				return Elementarist.SpellList["Blood Fury"]
			end
		end

		return ""
	end;
	IntSpell = function(self)
		-- interruptions, purge, and AoE on target
		local d
		
		---- Earthquake with Enhanced chain lightning buff 
		d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Earthquake"])
		if (d) and (d<0.5) then
			eclBuff, _, _, _, _, _, eclExp = Elementarist:hasBuff("player",Elementarist.SpellList["EnhancedChainLightningBuff"]);
			if (eclBuff) then 
				return Elementarist.SpellList["Earthquake"]
			end
		end

		if (Elementarist.person["foeCount"]>2) then 
			----  Lava beam if available
			if Elementarist:SpellAvailable(Elementarist.SpellList["Lava Beam"]) then
				if IsSpellInRange(Elementarist.SpellList["Lava Beam"], "target") == 1 then
					d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Lava Beam"])
					return Elementarist.SpellList["Lava Beam"]
				end
			end

			---- Earth shock if Lightning Shield count >=17 and not on cd
			d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Earth Shock"])
			if (d) and (d<0.5) then 
				local _, _, _, lscount = Elementarist:hasBuff("player",Elementarist.SpellList["Lightning Shield"]) 
				if (lscount) then 
					lscount= lscount + (Elementarist:Count(Elementarist.SpellList["Lightning Bolt"],spellInCast,exspell1,exspell2));
					lscount= lscount + (Elementarist:Count(Elementarist.SpellList["Lava Burst"],spellInCast,exspell1,exspell2));
				else
					lscount=0;
				end
				if (lscount>=17) then
					return Elementarist.SpellList["Earth Shock"]
				end
			end

			----  When Earthquake available get Enhanced chain lightning buff 
			if (not eclBuff) then
				d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Earthquake"])
				if (d) and (d<0.5 + Elementarist.lastBaseGCD) then
					if Elementarist:SpellAvailable(Elementarist.SpellList["Chain Lightning"]) then
						return Elementarist.SpellList["Chain Lightning"]
					end
				end
			end

			---- Chain Lightning as filler 
			if Elementarist:SpellAvailable(Elementarist.SpellList["Chain Lightning"]) then
				return Elementarist.SpellList["Chain Lightning"]
			end
		end
		
		if Elementarist:SpellAvailable(Elementarist.SpellList["Wind Shear"]) then
			if IsSpellInRange(Elementarist.SpellList["Wind Shear"], "target") == 1 then
				local _, status, threatpct, _, _ = UnitDetailedThreatSituation("player", "target")
				if ((UnitCastingInfo("target")) or (UnitChannelInfo("target"))) or ((status) and (threatpct>80) and (Elementarist.person["friendCount"]>1) and (Elementarist.inParty>0)) then
					d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Wind Shear"])
					if (d) and (d<0.5) and (IsSpellInRange(Elementarist.SpellList["Wind Shear"], "target") ) then
						return Elementarist.SpellList["Wind Shear"]
					end
				end
			
				if (UnitChannelInfo("target")) then
					d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Wind Shear"])
					if (d<0.5) and (interruptable) and (IsSpellInRange(Elementarist.SpellList["Wind Shear"], "target") ) then
						return Elementarist.SpellList["Wind Shear"]
					end
				end
			end
		end

		-- check if purgeable buff is on target (not sure if this is ok)
		if Elementarist:SpellAvailable(Elementarist.SpellList["Purge"]) then
			if IsSpellInRange(Elementarist.SpellList["Purge"], "target") == 1 then
				if (Elementarist:hasBuff("target", ".", 1)) then
					d = Elementarist:GetSpellCooldownRemaining(Elementarist.SpellList["Purge"])
					if (d) and (d<0.5) then
						return Elementarist.SpellList["Purge"]
					end
				end
			end
		end
	
		return ""
	end;
	ShieldName = function(self)
		return "Lightning Shield";
	end;

};
