#GridResizeFrames#

A simple layout for grid that allows the user to define set frame widths/heights based on the number of raid groups being shown. 

Many people (myself included) have UIs that provide a finite or limited space for Grid's raid frames. If you're like me, you've setup Grid to occupy that space perfectly for a specific raid size (25m or LFR for example) but run into the issue of Grid overlapping onto other UI elements when doing world bosses.

I wrote this specifically to address that situation, and to provide a more flexible Grid frame that meets the demands of the more flexible raid sizes in WoD. With this layout, when the raid size changes, the Grid frame width/height is re-adjusted per user defined values depending on how many groups are being displayed. A 10m group can have fairly wide/tall frames, while a 40m world boss group will have short/thin frames but neither group size will cause UI overlap.

The layout is intended to be a catch-all replacement layout for anyone that doesn't use "w/ Tanks" or "w/ Pets" layouts. You can chose to use this layout for all of the various pre-defined situations that Grid provides.

##Usage##
1. Open the Grid options UI
2. Select the Layout Tab
3. Choose "Resize Frame" for any of the layouts that you would like to use this on
4. Select the GridResizeFrames Tab
5. Adjust the values according to your preferences (these values can be adjusted on-the-fly while in raid too)
6. Profit! :D

##Cavets##
If you are currently in a raid/group and switch to this layout from another, you will need to either reload your UI, or wait for the group to change before any resizing is done. This, unfortunately, is a limitation of Grid and there isn't much I can do about it.

##Horizontal Group Mode!##
Since enough people have shown interest in support for Grid's horizontal group mode, I have included a basic method to resize frame height when using horizontal groups.
Currently, GridResizeFrames functions in a "one-or-the-other" mode based on the user's Grid setup. If you have horizontal groups enabled, then only height resizing is available. If you are not using horizontal groups, then only width resizing is available.

##Translators Needed!##
I have done the best that I can on my own to translate all the various strings this addon uses, but I just know some of these translations are wrong. If you are well versed in another language, head on over to http://wow.curseforge.com/addons/gridresizeframes/localization/ and help me get the translations correct!