--[[
	Project....: LUI NextGenWoWUserInterface
	File.......: totot.lua
	Description: oUF TargetTargetTarget Defaults
]] 

local addonname, LUI = ...
local module = LUI:Module("Unitframes")

module.defaults.profile.ToToT = {
	Enable = false,
	Height = 24,
	Width = 200,
	X = 465,
	Y = -285,
	Point = "CENTER",
	Scale = 1,
	Border = {
		EdgeFile = "glow",
		EdgeSize = 5,
		Insets = {
			Left = 3,
			Right = 3,
			Top = 3,
			Bottom = 3,
		},
		Color = {
			r = 0,
			g = 0,
			b = 0,
			a = 1,
		},
	},
	Backdrop = {
		Texture = "Blizzard Tooltip",
		Padding = {
			Left = -4,
			Right = 4,
			Top = 4,
			Bottom = -4,
		},
		Color = {
			r = 0,
			g = 0,
			b = 0,
			a = 1,
		},
	},
	Bars = {
		Health = {
			Height = 24,
			Width = 200,
			X = 0,
			Y = 0,
			Color = "By Class",
			Texture = "LUI_Gradient",
			TextureBG = "LUI_Gradient",
			BGAlpha = 1,
			BGMultiplier = 0.4,
			BGInvert = false,
			Smooth = true,
			IndividualColor = {
				r = 0.3,
				g = 0.3,
				b = 0.3,
			},
		},
		Power = {
			Enable = false,
			Height = 10,
			Width = 200,
			X = 0,
			Y = -26,
			Color = "By Class",
			Texture = "LUI_Minimalist",
			TextureBG = "LUI_Minimalist",
			BGAlpha = 1,
			BGMultiplier = 0.4,
			BGInvert = false,
			Smooth = true,
			IndividualColor = {
				r = 0.8,
				g = 0.8,
				b = 0.8,
			},
		},
		Full = {
			Enable = false,
			Height = 14,
			Width = 200,
			X = 0,
			Y = -36,
			Texture = "LUI_Minimalist",
			Alpha = 1,
			IndividualColor = {
				r = 0.11,
				g = 0.11,
				b = 0.11,
				a = 1,
			},
		},
	},
	Aura = {
		Buffs = {
			Enable = false,
			ColorByType = false,
			PlayerOnly = false,
			IncludePet = false,
			AuraTimer = false,
			DisableCooldown = false,
			CooldownReverse = true,
			X = -0.5,
			Y = -30,
			InitialAnchor = "BOTTOMRIGHT",
			GrowthY = "DOWN",
			GrowthX = "LEFT",
			Size = 26,
			Spacing = 2,
			Num = 8,
		},
		Debuffs = {
			Enable = false,
			ColorByType = false,
			PlayerOnly = false,
			IncludePet = false,
			FadeOthers = true,
			AuraTimer = false,
			DisableCooldown = false,
			CooldownReverse = true,
			X = -0.5,
			Y = -60,
			InitialAnchor = "BOTTOMLEFT",
			GrowthY = "DOWN",
			GrowthX = "RIGHT",
			Size = 26,
			Spacing = 2,
			Num = 36,
		},
	},
	Portrait = {
		Enable = false,
		Height = 43,
		Width = 90,
		X = 0,
		Y = 0,
		Alpha = 1,
	},
	Icons = {
		Lootmaster = {
			Enable = false,
			Size = 15,
			X = 16,
			Y = 0,
			Point = "TOPLEFT",
		},
		Leader = {
			Enable = false,
			Size = 17,
			X = 0,
			Y = 0,
			Point = "TOPLEFT",
		},
		Role = {
			Enable = false,
			Size = 22,
			X = 15,
			Y = 10,
			Point = "TOPRIGHT",
		},
		Raid = {
			Enable = true,
			Size = 55,
			X = 0,
			Y = 0,
			Point = "CENTER",
		},
		PvP = {
			Enable = false,
			Size = 35,
			X = -12,
			Y = 10,
			Point = "TOPLEFT",
		},
	},
	Texts = {
		Name = {
			Enable = true,
			Font = "Prototype",
			Size = 15,
			X = 5,
			Y = 0,
			IndividualColor = {
				r = 1,
				g = 1,
				b = 1,
			},
			Outline = "NONE",
			Point = "LEFT",
			RelativePoint = "LEFT",
			Format = "Name",
			Length = "Medium",
			ColorNameByClass = false,
			ColorClassByClass = false,
			ColorLevelByDifficulty = false,
			ShowClassification = false,
			ShortClassification = false,
		},
		Health = {
			Enable = false,
			Font = "Prototype",
			Size = 24,
			X = 0,
			Y = -43,
			Color = "Individual",
			ShowAlways = true,
			IndividualColor = {
				r = 0,
				g = 0,
				b = 0,
			},
			Outline = "NONE",
			Point = "BOTTOMLEFT",
			RelativePoint = "BOTTOMRIGHT",
			Format = "Absolut Short",
			ShowDead = false,
		},
		Power = {
			Enable = false,
			Font = "Prototype",
			Size = 24,
			X = 0,
			Y = -66,
			Color = "By Class",
			ShowFull = true,
			ShowEmpty = true,
			IndividualColor = {
				r = 0,
				g = 0,
				b = 0,
			},
			Outline = "NONE",
			Point = "BOTTOMLEFT",
			RelativePoint = "BOTTOMRIGHT",
			Format = "Absolut Short",
		},
		HealthPercent = {
			Enable = true,
			Font = "Prototype",
			Size = 14,
			X = -5,
			Y = 0,
			Color = "Individual",
			ShowAlways = false,
			IndividualColor = {
				r = 1,
				g = 1,
				b = 1,
			},
			Outline = "NONE",
			Point = "RIGHT",
			RelativePoint = "RIGHT",
			ShowDead = false,
		},
		PowerPercent = {
			Enable = false,
			Font = "Prototype",
			Size = 24,
			X = 0,
			Y = 0,
			Color = "Individual",
			ShowFull = false,
			ShowEmpty = false,
			IndividualColor = {
				r = 0,
				g = 0,
				b = 0,
			},
			Outline = "NONE",
			Point = "CENTER",
			RelativePoint = "CENTER",
		},
		HealthMissing = {
			Enable = false,
			Font = "Prototype",
			Size = 24,
			X = 0,
			Y = 0,
			Color = "Individual",
			ShortValue = true,
			ShowAlways = false,
			IndividualColor = {
				r = 0,
				g = 0,
				b = 0,
			},
			Outline = "NONE",
			Point = "RIGHT",
			RelativePoint = "RIGHT",
		},
		PowerMissing = {
			Enable = false,
			Font = "Prototype",
			Size = 24,
			X = 0,
			Y = 0,
			Color = "Individual",
			ShortValue = true,
			ShowFull = false,
			ShowEmpty = false,
			IndividualColor = {
				r = 0,
				g = 0,
				b = 0,
			},
			Outline = "NONE",
			Point = "RIGHT",
			RelativePoint = "RIGHT",
		},
	},
	Fader = {
		Casting = true,
		Combat = true,
		Enable = false,
		Health = true,
		HealthClip = 1.0,
		Hover = true,
		HoverAlpha = 0.75,
		InAlpha = 1.0,
		OutAlpha = 0.1,
		OutDelay = 0.0,
		OutTime = 1.5,
		Power = true,
		PowerClip = 0.9,
		Targeting = true,
		UseGlobalSettings = true,
	},
}
